/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    private static volatile Thread sMainThread;
    private static volatile Handler sMainThreadHandler;
    private static volatile Handler sIoThreadHandler;
    private static volatile ExecutorService sSingleThreadExecutor;
    private static volatile ExecutorService sWorkThreadExecutor;
    private static final int CPU_COUNT;

    public static boolean isMainThread() {
        if (sMainThread == null) {
            sMainThread = Looper.getMainLooper().getThread();
        }
        return Thread.currentThread() == sMainThread;
    }

    public static Handler getUiThreadHandler() {
        if (sMainThreadHandler == null) {
            sMainThreadHandler = new Handler(Looper.getMainLooper());
        }
        return sMainThreadHandler;
    }

    public static void ensureMainThread() {
        if (!ThreadUtils.isMainThread()) {
            throw new RuntimeException("Must be called on the UI thread");
        }
    }

    public static void postOnBackgroundThread(Runnable runnable) {
        if (sSingleThreadExecutor == null) {
            sSingleThreadExecutor = Executors.newSingleThreadExecutor();
        }
        sSingleThreadExecutor.execute(runnable);
    }

    public static void postOnWorkThreadPool(Runnable runnable) {
        if (sWorkThreadExecutor == null) {
            sWorkThreadExecutor = new ThreadPoolExecutor(CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        sWorkThreadExecutor.execute(runnable);
    }

    public static void postOnMainThread(Runnable runnable) {
        ThreadUtils.getUiThreadHandler().post(runnable);
    }

    public static Handler getIoThreadHandler() {
        if (sIoThreadHandler == null) {
            HandlerThread handlerThread = new HandlerThread("io");
            handlerThread.start();
            sIoThreadHandler = new Handler(handlerThread.getLooper());
        }
        return sIoThreadHandler;
    }

    static {
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
    }
}

