/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib;

import android.util.Log;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class SingleLiceFactory<T, S extends T> {
    private static final String TAG = "SingleLiceFactory";
    private static boolean DEBUG = true;
    private final Class<T> mInterfaceClass;
    private final Supplier<T> mFuncInstanceDefault;
    private final Supplier<S> mFuncInstance;
    private S mServiceLice;
    private T mDefaultServiceLice;

    public SingleLiceFactory(Class<T> interfaceClass, Supplier<T> funcInstanceDefault, Supplier<S> funcInstance) {
        this.mInterfaceClass = interfaceClass;
        this.mFuncInstanceDefault = funcInstanceDefault;
        this.mFuncInstance = funcInstance;
    }

    public S instance() {
        if (this.mServiceLice == null) {
            this.mServiceLice = this.mFuncInstance.get();
        }
        return this.mServiceLice;
    }

    public T instance(String className) {
        Object res = null;
        Class<T> callerClass = this.mInterfaceClass;
        try {
            Class<?> classFactory = Class.forName(className, true, callerClass.getClassLoader());
            Method methodInstance = classFactory.getDeclaredMethod("instance", new Class[0]);
            Object obj = methodInstance.invoke(classFactory, new Object[0]);
            if (this.mInterfaceClass.isInstance(obj)) {
                res = obj;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("instance successfully. " + obj + " from " + callerClass.getName()));
                }
            } else if (obj != null) {
                Log.w((String)TAG, (String)("instance failed. " + obj + "  from " + callerClass.getName()));
            }
        }
        catch (Throwable e) {
            if (DEBUG) {
                Log.w((String)TAG, (String)("instance failed. " + className + "  from " + callerClass.getName()), (Throwable)e);
            }
            Log.w((String)TAG, (String)("instance failed. " + className + "  from " + callerClass.getName() + " " + e));
        }
        if (res == null) {
            if (this.mDefaultServiceLice == null) {
                this.mDefaultServiceLice = this.mFuncInstanceDefault.get();
            }
            res = this.mDefaultServiceLice;
            Log.d((String)TAG, (String)("using " + this.mDefaultServiceLice + " instead of " + className + "  from " + callerClass.getName()));
        }
        return (T)res;
    }
}

