/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.List;
import tech.palm.lib.utils.AdvertisingIdClient;

public class CloudUtils {
    private static final String TAG = "CloudManager";
    public static final String STATE_PROVIDER_NAME = "tech.palm.cloud.CloudSyncStateProvider";
    public static final String DEVICE_INFO__PROVIDER_NAME = "com.hoffnung.DeviceInfoProvider";
    public static final String PACKAGE_NAME_PALM_ID = "tech.palm.id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"all"})
    public static boolean isCloudSyncOn(Context context) {
        Cursor cursor = null;
        try {
            cursor = CloudUtils.getAllCloudSyncState(context);
            boolean isContactOn = false;
            boolean isBlockOn = false;
            boolean isWlanOn = false;
            while (cursor != null && cursor.moveToNext()) {
                String booleanStr;
                if (1 == cursor.getInt(cursor.getColumnIndex("category"))) {
                    booleanStr = cursor.getString(cursor.getColumnIndex("sync_state"));
                    isContactOn = Boolean.valueOf(booleanStr);
                }
                if (2 == cursor.getInt(cursor.getColumnIndex("category"))) {
                    booleanStr = cursor.getString(cursor.getColumnIndex("sync_state"));
                    isBlockOn = Boolean.valueOf(booleanStr);
                }
                if (3 != cursor.getInt(cursor.getColumnIndex("category"))) continue;
                booleanStr = cursor.getString(cursor.getColumnIndex("sync_state"));
                isWlanOn = Boolean.valueOf(booleanStr);
            }
            boolean bl = isContactOn || isBlockOn || isWlanOn;
            return bl;
        }
        finally {
            if (null != cursor && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"all"})
    public static boolean isCloudSyncOn(Context context, int type) {
        Cursor cursor = null;
        try {
            cursor = CloudUtils.getAllCloudSyncState(context);
            while (cursor != null && cursor.moveToNext()) {
                if (type != cursor.getInt(cursor.getColumnIndex("category"))) continue;
                String booleanStr = cursor.getString(cursor.getColumnIndex("sync_state"));
                boolean bl = Boolean.valueOf(booleanStr);
                return bl;
            }
        }
        finally {
            if (null != cursor && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return false;
    }

    public static Cursor getAllCloudSyncState(Context context) {
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = null;
        Uri uri = Uri.parse((String)"content://tech.palm.cloud.CloudSyncStateProvider/syncState");
        try {
            cursor = cr.query(uri, null, null, null, null);
            return cursor;
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)("get state fail, cause" + e.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"all"})
    public static DeviceInfo getDeviceInfo(Context context) {
        DeviceInfo deviceInfo = new DeviceInfo();
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = null;
        Uri uri = Uri.parse((String)"content://com.hoffnung.DeviceInfoProvider");
        try {
            cursor = cr.query(uri, null, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                deviceInfo.mDeviceId = cursor.getString(cursor.getColumnIndex("cpuid"));
                deviceInfo.mClientId = cursor.getString(cursor.getColumnIndex("clientid"));
            } else {
                deviceInfo.mDeviceId = AdvertisingIdClient.getGoogleAdId(context);
            }
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)("get state fail, cause" + e.getMessage()));
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return deviceInfo;
    }

    public static boolean isPalmIdForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null && list.size() > 0) {
            ActivityManager.RunningAppProcessInfo curr = (ActivityManager.RunningAppProcessInfo)list.get(0);
            String[] pkgList = curr.pkgList;
            for (int i = 0; i < pkgList.length; ++i) {
                if (!context.getPackageName().equals(pkgList[i]) || curr.importance > 100) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPackageNameByUid(Context context, int uid) {
        String packageName = "";
        if (context == null) {
            return packageName;
        }
        PackageManager packageManager = context.getPackageManager();
        String[] packages = packageManager.getPackagesForUid(uid);
        if (packages != null && packages.length >= 0) {
            packageName = packages[0];
        }
        return packageName;
    }

    public static String reflectGetReferrer(Activity activity) {
        try {
            Class<?> activityClass = Class.forName("android.app.Activity");
            Field refererField = activityClass.getDeclaredField("mReferrer");
            refererField.setAccessible(true);
            String referrer = (String)refererField.get(activity);
            return referrer;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return "No referrer";
        }
    }

    public static class DeviceInfo {
        private String mDeviceId = "";
        private String mClientId = "";

        public String getDeviceId() {
            return this.mDeviceId;
        }

        public String getClientId() {
            return this.mClientId;
        }
    }
}

