package tech.palm.lib;

import android.util.Log;

import java.lang.reflect.Method;
import java.util.function.Supplier;

public class LiceInfo<I> {
    private static final String TAG = "LiceInfo";
    private static boolean DEBUG = true;

    private final Class<I> mInterfaceClass;
    private final String mImplClassName;
    private final Supplier<I> mFuncDefault;
    private volatile I mImpl;
    public LiceInfo(
            String implClassName,
            Class<I> interfaceClass,
            Supplier<I> funcDefault) {
        mInterfaceClass = interfaceClass;
        mImplClassName = implClassName;
        mFuncDefault = funcDefault;
        mImpl = null;
    }
    public I getImpl() {
        if (mImpl != null) {
            return mImpl;
        }
        synchronized (mInterfaceClass) {
            if (mImpl != null) {
                return mImpl;
            }
            Object obj = null;
            final Class<?> callerClass = mInterfaceClass;
            try {
                final Class<?> classFactory = Class.forName(mImplClassName, true, callerClass.getClassLoader());
                Method methodInstance = classFactory.getDeclaredMethod("instance");
                obj = methodInstance.invoke(classFactory);
            } catch (Throwable e) {
                if (DEBUG) {
                    Log.w(TAG, "instance failed. "
                            + mImplClassName + " from " + callerClass.getName(), e);
                } else {
                    Log.w(TAG, "instance failed."
                            + " className:" + mImplClassName + " from " + callerClass.getName() + " " + e);
                }
            }
            if (mInterfaceClass.isInstance(obj)) {
                mImpl = (I)obj;
                if (DEBUG) {
                    Log.d(TAG, "instance successfully. "
                            + obj + " from " + callerClass.getName());
                }
            } else {
                mImpl = mFuncDefault.get();
                Log.d(TAG, "using " + mImpl + " instead of "
                        + (obj != null ? obj : mImplClassName) + " from " + callerClass.getName());
            }
        }
        return mImpl;
    }

}
