package tech.palm.lib.account;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;

import org.json.JSONObject;

import tech.palm.lib.account.data.Token;

/**
 * @Description:
 * @author： 胡南 on 2021/5/10
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class XNManager {
    private XNManager(){

    }

    static class XNManagerInner{
        static XNManager instance = new XNManager();
    }
    public static XNManager getInstance(){
        return XNManagerInner.instance;
    }
    public boolean isLogged(Context context){
        Cursor cursor = context.getContentResolver()
                .query(ProviderConfig.URI_IS_LOGGED, null, null, null, null, null);
        return cursor != null && cursor.getCount() > 0;
    }

    @SuppressLint("all")
    public Token getToken(Context context){
        Cursor cursor = context.getContentResolver()
                .query(ProviderConfig.URI_TOKEN, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            Token token = new Token();
            cursor.moveToNext();
             token.token = cursor.getString(cursor.getColumnIndex(ProviderConfig.KEY_TOKEN));
             token.refreshToken = cursor.getString(cursor.getColumnIndex(ProviderConfig.KEY_REFRESH_TOKEN));
            cursor.close();
            return token;
        }
        return null;
    }

    @SuppressLint("all")
    public boolean havePwd(Context context){
        Log.d("com.palm.id.log", "start havePwd");
        Cursor cursor = context.getContentResolver()
                .query(ProviderConfig.URI_ACCOUNT, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToNext();

            String havePwd = cursor.getString(cursor.getColumnIndex(ProviderConfig.KEY_HAVE_PWD));
            Log.d("com.palm.id.log", "havePwd" + havePwd);
            cursor.close();
            return "true".equals(havePwd);
        }

        return false;
    }

    @SuppressLint("all")
    public String getUserId(Context context){
        Cursor cursor = context.getContentResolver()
                .query(ProviderConfig.URI_ACCOUNT, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToNext();
            String userId = cursor.getString(cursor.getColumnIndex(ProviderConfig.KEY_USER_ID));
            cursor.close();
            return userId;
        }
        return null;
    }

    public void saveToken(Context context,String token,String refreshToken){
        Cursor cursor = context.getContentResolver()
                .query(ProviderConfig.URI_SAVE_TOKEN, new String[]{token,refreshToken}, null, null, null, null);
        if (cursor != null){
            cursor.close();
        }
    }

    public void notifyUpdatePrivacy(Context context,String msg){
        try {
            JSONObject jsonObject = new JSONObject(msg);
            String privacyVersion = "";
            if (jsonObject.has("privacyVersion")){
                privacyVersion = jsonObject.getString("privacyVersion");
            }
            String userAgreement = "";
            if (jsonObject.has("userAgreement")){
                userAgreement = jsonObject.getString("userAgreement");
            }

            Cursor cursor = context.getContentResolver()
                    .query(ProviderConfig.URI_UPDATE_PRIVACY,
                            new String[]{privacyVersion,userAgreement},
                            null, null, null, null);
            if (cursor != null){
                cursor.close();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void logout(Context context){
        try {
            Cursor cursor = context.getContentResolver()
                    .query(ProviderConfig.URI_LOGOUT,
                            null,
                            null, null, null, null);
            if (cursor != null){
                cursor.close();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @SuppressLint("all")
    public String infoStatus(Context context){
        Cursor cursor = context.getContentResolver()
                .query(ProviderConfig.URI_INFO_STATUS, null, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToNext();
            String infoStatus = cursor.getString(cursor.getColumnIndex(ProviderConfig.KEY_INFO_STATUS));
            cursor.close();
            return infoStatus;
        }
        return "";
    }
}