package tech.palm.lib.cloud;


import android.content.Context;

import tech.palm.lib.CommonConstants.CLOUD;
import tech.palm.lib.LiceInfo;

public interface ICloudManager {

    class DefaultImpl implements ICloudManager {
    }

    LiceInfo<ICloudManager> sLiceInfo = new LiceInfo<>(
            "tech.palm.cloud.RemoteManager",
            ICloudManager.class,
            ICloudManager.DefaultImpl::new);

    static ICloudManager Instance() {
        return sLiceInfo.getImpl();
    }

    default void getSyncState(Context context, ISyncStateCallback callBack) {
    };

    default void clearCloudData(Context context, boolean autoLogout, @CLOUD.DataType int[] dataType, IClearDataCallback callBack) {
    };


    interface ISyncStateCallback {
        void onState(@CLOUD.SyncType int state);
    }

    interface IClearDataCallback {
        void onSuccess();
        void onFailure(@CLOUD.ClearErrorCode int errorCode);
    }
}
