package tech.palm.lib.remoteconifg;

import android.content.Context;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import tech.palm.lib.remoteconifg.configs.*;

public class RemoteConfigPool {

    private Context mContext;
    private static RemoteConfigPool mInstance;

    private RemoteConfigPool(Context context) {
        mContext = context;
    }

    public static RemoteConfigPool getInstance(Context context) {
        if (mInstance == null) {
            synchronized (RemoteConfigPool.class) {
                if (mInstance == null) {
                    mInstance = new RemoteConfigPool(context);
                }
            }
        }
        return mInstance;
    }

    public boolean getSettingRedPointSwitchOn() {
        SettingRedPointSwitchRemoteConfig mSettingRedPointSwitchRemoteConfig = new SettingRedPointSwitchRemoteConfig(mContext);
        return mSettingRedPointSwitchRemoteConfig.getStatus();
    }

}
