package tech.palm.lib.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;

public class ProcessConfig {
    private static final String MAIN_PROCESS_NAME = "tech.palm.id";
    private static final String CLOUD_PROCESS_NAME = ":cloud";

    private static String sCurrentProcessName = null;

    public static boolean isMainProcess(Context context) {
        if (context == null) {
            return true;
        }
        String packageName = context.getPackageName();
        if (packageName == null) {
            return true;
        }
        String processName = getProcessName(context);
        if (processName == null) {
            return true;
        }
        return packageName.equalsIgnoreCase(processName) || MAIN_PROCESS_NAME.equalsIgnoreCase(processName);
    }

    public static boolean isCloudProcess(Context context) {
        String processName = getProcessName(context);
        if (processName == null) {
            return false;
        }
        if (processName.contains(CLOUD_PROCESS_NAME)) {
            return true;
        }
        return false;
    }

    private static String getProcessName(Context context) {
        try {
            if (sCurrentProcessName != null) {
                return sCurrentProcessName;
            }
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                sCurrentProcessName = Application.getProcessName();
                return sCurrentProcessName;
            }
            int pid = Process.myPid();
            ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid == pid) {
                    sCurrentProcessName = processInfo.processName;
                    return sCurrentProcessName;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sCurrentProcessName;
    }
}
