/*Transsion Top Secret*/
package tech.palm.lib.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {

    private static volatile Thread sMainThread;
    private static volatile Handler sMainThreadHandler;
    private static volatile Handler sIoThreadHandler;
    private static volatile ExecutorService sSingleThreadExecutor;
    private static volatile ExecutorService sWorkThreadExecutor;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();

    /**
     * Returns true if the current thread is the UI thread.
     */
    public static boolean isMainThread() {
        if (sMainThread == null) {
            sMainThread = Looper.getMainLooper().getThread();
        }
        return Thread.currentThread() == sMainThread;
    }

    /**
     * Returns a shared UI thread handler.
     */
    public static Handler getUiThreadHandler() {
        if (sMainThreadHandler == null) {
            sMainThreadHandler = new Handler(Looper.getMainLooper());
        }

        return sMainThreadHandler;
    }

    /**
     * Checks that the current thread is the UI thread. Otherwise throws an exception.
     */
    public static void ensureMainThread() {
        if (!isMainThread()) {
            throw new RuntimeException("Must be called on the UI thread");
        }
    }

    /**
     * Posts runnable in background using shared background thread pool.
     */
    public static void postOnBackgroundThread(Runnable runnable) {
        if (sSingleThreadExecutor == null) {
            sSingleThreadExecutor = Executors.newSingleThreadExecutor();
        }
        sSingleThreadExecutor.execute(runnable);
    }

    /**
     * Post runnable in background using thread pool with multy thread.
     */
    public static void postOnWorkThreadPool(Runnable runnable) {
        if (sWorkThreadExecutor == null) {
            sWorkThreadExecutor = new ThreadPoolExecutor(CPU_COUNT + 1,
                    2 * CPU_COUNT + 1,
                    30, TimeUnit.SECONDS,
                    new LinkedBlockingQueue<Runnable>());
        }
        sWorkThreadExecutor.execute(runnable);
    }

    /**
     * Posts the runnable on the main thread.
     */
    public static void postOnMainThread(Runnable runnable) {
        getUiThreadHandler().post(runnable);
    }

    public static Handler getIoThreadHandler() {
        if (sIoThreadHandler == null) {
            HandlerThread handlerThread = new HandlerThread("io");
            handlerThread.start();
            sIoThreadHandler = new Handler(handlerThread.getLooper());
        }

        return sIoThreadHandler;
    }
}
