package tech.palm.lib.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import android.text.TextUtils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import static android.provider.Settings.Global.AUTO_TIME;

public class CommonUtils {

    public static final long SECOND_IN_MILLIS = 1000;
    public static final long MIN_IN_MILLIS = 60 * SECOND_IN_MILLIS;
    public static final long HOUR_IN_MILLIS = 60 * MIN_IN_MILLIS;
    public static final long DAY_IN_MILLIS = 24 * HOUR_IN_MILLIS;
    public static final long WEEK_IN_MILLIS = 7 * DAY_IN_MILLIS;
    public static final long MONTH_IN_MILLIS = 30 * DAY_IN_MILLIS;

    public static String transferMillisToDate(String dateFormat, long millsec) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        Date date = new Date(millsec);
        return sdf.format(date);
    }

    public static String transferMillisToDate(long millsec) {
        return transferMillisToDate("yyyy-MM-dd HH:mm:ss", millsec);
    }

    @SuppressLint("MissingPermission")
    public static boolean isNetworkConnected(Context context) {
        if (context != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager) context
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isAvailable();
            }
        }
        return false;
    }

    public static boolean isPalmIdSystemApp(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo pi = packageManager.getPackageInfo(context.getPackageName(), 0);
            return (pi.applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isAutoTimeEnabled(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), AUTO_TIME, 0) > 0;
    }

    public static String SystemPropertiesGet(String key) {
        try {
            Class cl = Class.forName("android.os.SystemProperties");
            Method method = cl.getMethod("get", String.class);
            String value = (String) method.invoke(null, key);
            return value;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getOsVersion() {
        String osVersion = SystemPropertiesGet("ro.tranos.version");
        if (TextUtils.isEmpty(osVersion)) {
            osVersion = SystemPropertiesGet("ro.os_product.version");
        }
        return osVersion;
    }

    public static String getBuildVerName() {
        try {
            Class clazz = Class.forName("tech.palm.id.BuildConfig");
            Field field = clazz.getField("VERSION_NAME");
            return (String)(field.get(null));
        } catch (Exception e) {
        }
        return "";
    }

    public static int getBuildVerCode() {
        try {
            Class clazz = Class.forName("tech.palm.id.BuildConfig");
            Field field = clazz.getField("VERSION_CODE");
            return (int)(field.get(null));
        } catch (Exception e) {
        }
        return 0;
    }

    public static String getStackTrace(Throwable throwable, int stackCount) {
        try {
            StackTraceElement[] ste = throwable.getStackTrace();
            StringBuilder message = new StringBuilder(throwable.toString());
            int i = 0;
            for (StackTraceElement element : ste) {
                message.append("#" + element.getClassName()).append(".")
                        .append(element.getMethodName())
                        .append("[" + element.getLineNumber() + "]");
                i++;
                if (i >= stackCount) {
                    break;
                }
            }
            return message.toString();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public static boolean isFileExists(final File file) {
        return file != null && file.exists();
    }

    public static List<String> readFile2List(final File file, final int startLine,
                                             final int endLine) {
        if (!isFileExists(file)) {
            return null;
        }
        if (startLine > endLine) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String lineStr;
            int curLine = 1;
            List<String> listStr = new ArrayList<>();
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((lineStr = reader.readLine()) != null) {
                if (curLine > endLine) break;
                if (startLine <= curLine && curLine <= endLine) listStr.add(lineStr);
                ++curLine;
            }
            return listStr;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        } finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeList2File(final File file, final List<String> strMsg) {
        if (file == null) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (String str : strMsg) {
                writer.write(str);
                writer.newLine();
                writer.flush();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSHA256(String str){
        MessageDigest messageDigest;
        String encodestr = "";
        if (TextUtils.isEmpty(str)) {
            return encodestr;
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = byte2Hex(messageDigest.digest());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes){
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i=0;i<bytes.length;i++){
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length()==1){
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

//    public static boolean isInfinix() {
//        return "xos".equals(SystemProperties.get("ro.tranos.type"));
//    }
//
//    public static boolean isItel() {
//        return "itel".equals(SystemProperties.get("ro.tranos.type"));
//    }
//
//    public static boolean isTecno() {
//        return "hios".equals(SystemProperties.get("ro.tranos.type"));
//    }
}
