package tech.palm.lib.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;

import java.util.ArrayList;
import java.util.List;


public class TelecomUtil {

    private static final String TAG = "TelecomUtil";

    @SuppressLint("MissingPermission")
    public static List<String> getSubscribedIccids(Context context) {
        List<String> iccids = new ArrayList<>();
        SubscriptionManager subscriptionManager = context.getSystemService(SubscriptionManager.class);
        List<SubscriptionInfo> subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
        if (subscriptionInfos == null) {
            return null;
        }
        for (SubscriptionInfo info : subscriptionInfos) {
            String iccid = info.getIccId();
            iccids.add(iccid);
        }
        return iccids;
    }

    @SuppressLint("MissingPermission")
    public static String getSubscribedIccid(Context context, int slotId) {
        SubscriptionManager subscriptionManager = context.getSystemService(SubscriptionManager.class);
        List<SubscriptionInfo> subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
        if (subscriptionInfos == null) {
            return null;
        }
        if (subscriptionInfos.size() > slotId) {
            SubscriptionInfo info = subscriptionInfos.get(slotId);
            return info.getIccId();
        } else {
            return null;
        }
    }
}
