/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib;

import android.util.Log;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class LiceInfo<I> {
    private static final String TAG = "LiceInfo";
    private static boolean DEBUG = true;
    private final Class<I> mInterfaceClass;
    private final String mImplClassName;
    private final Supplier<I> mFuncDefault;
    private volatile I mImpl;

    public LiceInfo(String implClassName, Class<I> interfaceClass, Supplier<I> funcDefault) {
        this.mInterfaceClass = interfaceClass;
        this.mImplClassName = implClassName;
        this.mFuncDefault = funcDefault;
        this.mImpl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I getImpl() {
        if (this.mImpl != null) {
            return this.mImpl;
        }
        Class<I> clazz = this.mInterfaceClass;
        synchronized (clazz) {
            if (this.mImpl != null) {
                return this.mImpl;
            }
            Object obj = null;
            Class<I> callerClass = this.mInterfaceClass;
            try {
                Class<?> classFactory = Class.forName(this.mImplClassName, true, callerClass.getClassLoader());
                Method methodInstance = classFactory.getDeclaredMethod("instance", new Class[0]);
                obj = methodInstance.invoke(classFactory, new Object[0]);
            }
            catch (Throwable e) {
                if (DEBUG) {
                    Log.w((String)TAG, (String)("instance failed. " + this.mImplClassName + " from " + callerClass.getName()), (Throwable)e);
                }
                Log.w((String)TAG, (String)("instance failed. className:" + this.mImplClassName + " from " + callerClass.getName() + " " + e));
            }
            if (this.mInterfaceClass.isInstance(obj)) {
                this.mImpl = obj;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("instance successfully. " + obj + " from " + callerClass.getName()));
                }
            } else {
                this.mImpl = this.mFuncDefault.get();
                Log.d((String)TAG, (String)("using " + this.mImpl + " instead of " + (obj != null ? obj : this.mImplClassName) + " from " + callerClass.getName()));
            }
        }
        return this.mImpl;
    }
}

