package tech.palm.lib.remoteconifg;

import android.content.Context;
import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

public class JsonRemoteConfigGetter {

    private String mConfigName;
    private String mConfigValue;
    private JSONObject mValueJson;
    private Context mContext;

    public JsonRemoteConfigGetter(Context context, String configName) {
        mConfigName = configName;
        mContext = context;
        mConfigValue = RemoteConfigGetter.getStringValue(context, configName);
        if (!TextUtils.isEmpty(mConfigValue)) {
            try {
                mValueJson = new JSONObject(mConfigValue);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public String getValueString() {
        return mConfigValue;
    }

    public JSONObject getValueJson() {
        return mValueJson;
    }

    public JSONObject getDefaultJson() {
        return null;
    }

    public int getInt(String key) throws JSONException{
        if (mValueJson == null) {
            return -1;
        } else {
            return mValueJson.getInt(key);
        }
    }

    public String getString(String key) throws JSONException{
        if (mValueJson == null) {
            return null;
        } else {
            return mValueJson.getString(key);
        }
    }
}
