package tech.palm.lib.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;

import java.lang.reflect.Field;
import java.util.List;

import tech.palm.lib.CommonConstants;
import tech.palm.lib.CommonConstants.CLOUD.DataType;

public class CloudUtils {

    private static final String TAG = "CloudManager";

    public static final String STATE_PROVIDER_NAME = "tech.palm.cloud.CloudSyncStateProvider";
    public static final String DEVICE_INFO__PROVIDER_NAME = "com.hoffnung.DeviceInfoProvider";
    public static final String PACKAGE_NAME_PALM_ID = "tech.palm.id";

    @SuppressLint("all")
    public static boolean isCloudSyncOn(Context context) {
        Cursor cursor = null;
        try {
            cursor = getAllCloudSyncState(context);
            boolean isContactOn = false, isBlockOn = false, isWlanOn = false;
            while (cursor != null && cursor.moveToNext()) {
                if (DataType.CONTACT == cursor.getInt(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_CATEGROY))) {
                    String booleanStr = cursor.getString(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_SYNC_STATE));
                    isContactOn = Boolean.valueOf(booleanStr);
                }
                if (DataType.BLOCKNUM == cursor.getInt(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_CATEGROY))) {
                    String booleanStr = cursor.getString(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_SYNC_STATE));
                    isBlockOn = Boolean.valueOf(booleanStr);
                }
                if (DataType.WLAN == cursor.getInt(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_CATEGROY))) {
                    String booleanStr = cursor.getString(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_SYNC_STATE));
                    isWlanOn = Boolean.valueOf(booleanStr);
                }
            }
            return isContactOn || isBlockOn || isWlanOn;
        } finally {
            if (null != cursor && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    /**
     * type =
     * {@link tech.palm.lib.CommonConstants.CLOUD.DataType#CONTACT} or
     *{@link tech.palm.lib.CommonConstants.CLOUD.DataType#BLOCKNUM} or
     * {@link tech.palm.lib.CommonConstants.CLOUD.DataType#WLAN}
     */
    @SuppressLint("all")
    public static boolean isCloudSyncOn(Context context, int type) {
        Cursor cursor = null;
        try {
            cursor = getAllCloudSyncState(context);
            while (cursor != null && cursor.moveToNext()) {
                if (type == cursor.getInt(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_CATEGROY))) {
                    String booleanStr = cursor.getString(cursor.getColumnIndex(CommonConstants.CLOUD.KEY_SYNC_STATE));
                    return Boolean.valueOf(booleanStr);
                }
            }
        } finally {
            if (null != cursor && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return false;
    }

    public static Cursor getAllCloudSyncState(Context context) {

        ContentResolver cr = context.getContentResolver();
        Cursor cursor = null;
        Uri uri = Uri.parse("content://" + STATE_PROVIDER_NAME + "/syncState");
        try {
            cursor = cr.query(uri, null, null, null, null);
            return cursor;
        } catch (Exception e) {
            Log.i(TAG, "get state fail, cause" + e.getMessage());
            return null;
        }
    }

    public static class DeviceInfo {
        private String mDeviceId = "";
        private String mClientId = "";

        public String getDeviceId() {
            return mDeviceId;
        }

        public String getClientId() {
            return mClientId;
        }
    }

    @SuppressLint("all")
    public static DeviceInfo getDeviceInfo(Context context) {
        DeviceInfo deviceInfo = new DeviceInfo();

        ContentResolver cr = context.getContentResolver();
        Cursor cursor = null;
        Uri uri = Uri.parse("content://" + DEVICE_INFO__PROVIDER_NAME);
        try {
            cursor = cr.query(uri, null, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                deviceInfo.mDeviceId = cursor.getString(cursor.getColumnIndex("cpuid"));
                deviceInfo.mClientId = cursor.getString(cursor.getColumnIndex("clientid"));
            } else {
//                PackageManager packageManager = context.getPackageManager();
//                try {
//                    PackageInfo pi = packageManager.getPackageInfo("com.hoffnung", 0);
//                } catch (PackageManager.NameNotFoundException e) {
//                    deviceInfo.mDeviceId = AdvertisingIdClient.getGoogleAdId(context);
//                }//临时修改
                deviceInfo.mDeviceId = AdvertisingIdClient.getGoogleAdId(context);
            }
        } catch (Exception e) {
            Log.i(TAG, "get state fail, cause" + e.getMessage());
        } finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return deviceInfo;
    }


    public static boolean isPalmIdForeground(Context context) {
        ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> list = activityManager.getRunningAppProcesses();
        if (list !=null && list.size() > 0) {
            ActivityManager.RunningAppProcessInfo curr = list.get(0);
            String[] pkgList = curr.pkgList;
            for (int i = 0; i < pkgList.length; i ++) {
                if (context.getPackageName().equals(pkgList[i])) {
                    if (curr.importance <= ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getPackageNameByUid(Context context, int uid) {
        String packageName = "";
        if (context == null) {
            return packageName;
        }
        PackageManager packageManager = context.getPackageManager();
        String[] packages = packageManager.getPackagesForUid(uid);
        if (packages != null && packages.length >= 0) {
            packageName = packages[0];
        }

        return packageName;
    }

    public static  String reflectGetReferrer(Activity activity) {
        try {
            Class activityClass = Class.forName("android.app.Activity");

            Field refererField = activityClass.getDeclaredField("mReferrer");
            refererField.setAccessible(true);
            String referrer = (String) refererField.get(activity);
            return referrer;
        } catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return "No referrer";
        }
    }
}
