package com.transsion.xuanniao.account.api;

import android.app.Activity;
import android.content.Context;
import android.util.Log;

import com.transsion.palmsdk.PalmConstants;
import com.transsion.palmsdk.PalmID;
import com.transsion.palmsdk.account.XNManager;
import com.transsion.xuanniao.account.comm.mvpbase.BaseData;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.comm.utils.OSUtils;
import com.transsion.xuanniao.account.comm.utils.SystemPropertiesProxy;
import com.transsion.xuanniao.account.model.IApplyKeyMode;
import com.transsion.xuanniao.account.model.data.ApplyKeyReq;
import com.transsion.xuanniao.account.model.impl.ApplyKeyMode;

import java.io.Serializable;

import tech.palm.lib.net.BaseModeApp;

public class PalmInitialize implements Serializable {

    static {
        /**
         * 向PalmSDK提供账号访问接口
         */
        XNManager.getInstance().setAccountProvider(new XNManager.AccountProvider() {

            @Override
            public void applyKey(Context context, String clientId, int serverMode) {
                try {
                    if (serverMode == PalmConstants.SERVER_TEST
                            || SystemPropertiesProxy.getBoolean(context, "debug.palmsdk.test_mode", false)) {
                        BaseModeApp.MODE = BaseModeApp.TEST;
                        PalmConstants.SERVER_MODE = PalmConstants.SERVER_TEST;
                    } else if (serverMode == PalmConstants.SERVER_PRE) {
                        BaseModeApp.MODE = BaseModeApp.PRE;
                        PalmConstants.SERVER_MODE = PalmConstants.SERVER_PRE;
                    }
                } catch (Exception e) {
                    LogUtils.d(Log.getStackTraceString(e));
                }
                try {
                    OSUtils.isOldPalmID(context);  // 探测系统账号版本
                    XNApiManager.instance().setClientId(clientId);  // 保持clientId一致
                    if (TeeManager.instance().isTeeEnable()
                            && !TeeManager.instance().getIsKeyUploaded()
                            && NetUtils.instance().isNetworkConnected(context)) {
                        IApplyKeyMode applyKeyMode = new ApplyKeyMode();
                        ApplyKeyReq applyKeyReq = new ApplyKeyReq();
                        applyKeyReq.publicKey1061 = TeeManager.instance().exportSignatureKey(context);
                        applyKeyReq.keyId = TeeManager.instance().genKeyId(context);
                        applyKeyMode.applyKey(context, applyKeyReq, new NetCallBack<BaseData>(context, "", BaseData.class) {
                            @Override
                            public void onSuccess(int code, BaseData result, String tag) {
                                TeeManager.instance().saveKeyUploaded(true);
                            }

                            @Override
                            public void onRetry() {
                            }
                        });
                    }
                } catch (Exception e) {
                    LogUtils.d(Log.getStackTraceString(e));
                }
            }

            @Override
            public boolean isLogged(Context context) {
                return false;
            }

            @Override
            public boolean refreshToken(Context context, String tudcToken,
                                        PalmID.IPalmApiListener<String> apiListener) {
                return false;
            }

            @Override
            public void setToken(Context context, String aToken, String rToken) {

            }

            @Override
            public String getToken() {
                return null;
            }

            @Override
            public long getTokenExpiredTs(Context context) {
                return 0;
            }

            @Override
            public void getLoginRecord(Context context, int type,
                                       PalmID.IPalmApiListener<String> apiListener) {

            }

            @Override
            public String getAccountInfo(Context context) {
                return null;
            }

            @Override
            public void silentLogin(Context context, String requestId) {

            }

            @Override
            public void silentLogout(Context context, boolean isForce) {

            }

            @Override
            public void showBindPhoneDialog(Activity activity) {

            }
        });
    }
}
