package com.transsion.xuanniao.account.comm.constant;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

/**
 * PalmSDK使用常量
 */
public class PalmsKeys {

    public static final String ACTION_SILENT_LOGOUT = "intent.action.SILENT_LOGOUT"; // 退出登录
    public static final String ACTION_PALM_ID_CHANGE = "intent.action.PALM_ID_CHANGE"; // full sdk

    public static final String EXTRA_APP_ID = "appid";
    public static final String EXTRA_PACKAGE_NAME = "pkg_name";
    public static final String EXTRA_SCOPES = "scopes";
    public static final String EXTRA_REDIRECT_URI = "redirect_uri";
    public static final String EXTRA_AUTH_PARAM = "auth_param";
    public static final String EXTRA_ERROR_CODE = "error_code";
    public static final String EXTRA_ERROR_MESSAGE = "error_message";
    public static final String EXTRA_USER_INFO = "user_info";
    public static final String EXTRA_TOKEN_INFO = "token_info";
    public static final String EXTRA_AUTH_REQUEST = "auth_request";
    public static final String EXTRA_LINKED_ID = "linked_id";
    public static final String EXTRA_LINKED_PKG = "linked_pkg";  // 关联应用
    public static final String EXTRA_LINKED_BD = "linked_bd";  // 关联品牌
    public static final String EXTRA_NOTIFY = "notify";
    public static final String EXTRA_IS_LOGIN = "is_login";  // 区分登录/用户信息变更
    public static final String EXTRA_IS_LOCAL = "is_local";

    public static final String KEY_HOST_PALM_APP = "host_palm_app";
    public static final String GRANT_TYPE_CODE = "authorization_code";

    public static final int ERROR_NETWORK = 40103;           // 网络异常、读写超时
    public static final int ERROR_HTTP_REQ = 40104;       // http请求返回异常码
    public static final int TOKEN_TIMEOUT = 40055;
    public static final int ERROR_HOST_REQ = 49999;         // HOST应用异常/切换账号

    /**
     * FullSDK通知PalmID发生变化
     */
    public static void notifyChange(Context context, Bundle extras, boolean isLocal) {
        Intent intent = new Intent(ACTION_PALM_ID_CHANGE);
        if (extras != null) {
            intent.putExtras(extras);  // 带参数区分登录/用户信息变化
        }
        intent.putExtra(EXTRA_IS_LOCAL, isLocal);  // 区分PalmID广播/本地广播
        if (isLocal) {
            LocalBroadcastManager.getInstance(context).sendBroadcast(intent);
        } else {
            context.sendBroadcast(intent);
        }
    }
}
