package com.transsion.xuanniao.account.comm.mvpbase;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.core.os.ConfigurationCompat;

import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;
import com.transsion.widgetslib.dialog.OSLoadingBottomDialog;
import com.transsion.widgetslib.util.Utils;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import java.lang.ref.WeakReference;
import java.util.IllegalFormatConversionException;
import java.util.Locale;
import java.util.UnknownFormatConversionException;

/**
 * @Description:
 * @author： HuNan on 2020/5/19
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class BaseActivity extends Activity{
//    private OSLoadingBottomDialog osLoadingBottomDialog;
    private Dialog mDialog;
//    private LoadingDialog loadingDialog;
//    private WaitDialog dialog;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        setAppTheme();
        super.onCreate(savedInstanceState);
        CoreUtil.init(this);
//        StatusBarUtil.setStatusBarColor(this, getStatusBarColor(), getNavigationBarColor());

        Locale defLocale = Build.VERSION.SDK_INT >= Build.VERSION_CODES.N ? LocaleList.getDefault().get(0) : Locale.getDefault();
        Window window = getWindow();
        LogUtils.d("defLocale = " + defLocale + ", window = " + window);
        if (defLocale != null && window != null) {
            int layoutDirection = TextUtils.getLayoutDirectionFromLocale(defLocale);
            LogUtils.d("layoutDirection = " + layoutDirection);
            window.getDecorView().setLayoutDirection(layoutDirection);
        }
    }

    @Override
    public void attachBaseContext(Context newBase) {
        Locale sysLocale = ConfigurationCompat.getLocales(Resources.getSystem().getConfiguration()).get(0);
        Locale defLocale = Build.VERSION.SDK_INT >= Build.VERSION_CODES.N ? LocaleList.getDefault().get(0) : Locale.getDefault();
        LogUtils.d("sysLocale = " + sysLocale + ", defLocale = " + defLocale);
        if (sysLocale == defLocale || defLocale == null) {
            super.attachBaseContext(newBase);
            return;
        }
        try {
            Locale.setDefault(defLocale);
            Resources resources = newBase.getResources();
            Configuration configuration = resources.getConfiguration();
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                configuration.setLocales(new LocaleList(defLocale));
            } else {
                configuration.locale = defLocale;
                resources.updateConfiguration(configuration, resources.getDisplayMetrics());
            }
            Context context = Build.VERSION.SDK_INT >= Build.VERSION_CODES.N_MR1 ? newBase.createConfigurationContext(configuration) : newBase;
            ContextThemeWrapper wrappedContext = new ContextThemeWrapper(context, R.style.Theme_AppCompat_Empty) {
                @Override
                public void applyOverrideConfiguration(Configuration newConfiguration) {
                    newConfiguration.setTo(configuration);
                    super.applyOverrideConfiguration(newConfiguration);
                }
            };
            super.attachBaseContext(wrappedContext);
        } catch (Exception e) {
            super.attachBaseContext(newBase);
        }
    }
    
    /**
     * 主题与品牌OS一致
     */
    public void setAppTheme() {
        try {
            if (getResources().getBoolean(R.bool.sdk_theme_is_dynamic)) {
                Utils.setAppTheme(this, R.style.XNAppTheme,
                        R.style.XNAppTheme_xos, R.style.XNAppTheme);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                int vis = getWindow().getDecorView().getSystemUiVisibility();
                vis &= ~(View.SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR);
                getWindow().getDecorView().setSystemUiVisibility(vis);
            }
        } catch (Exception e) {
            LogUtils.d(Log.getStackTraceString(e));
        }
    }

    public int getStatusBarColor() {
        return R.color.xn_page_bg;
    }

    public int getNavigationBarColor() {
        return getStatusBarColor();
    }

    public void warning(String text) {
        Toast toast = Toast.makeText(getApplicationContext(), text, Toast.LENGTH_LONG);
        toast.setGravity(Gravity.CENTER, 0, 0);
        toast.show();
    }

    public void showWaitDialog(String msg) {
        if (!BaseActivity.this.isFinishing()) {
            if (mDialog != null && mDialog.isShowing()){
                mDialog.dismiss();
            }
            try {
                WeakReference<Activity> weakReference =  new WeakReference<>(this);
                if (weakReference.get() != null){
                    OSLoadingBottomDialog osLoadingBottomDialog = new OSLoadingBottomDialog(weakReference.get());
                    osLoadingBottomDialog.setMessage(msg);
                    mDialog = osLoadingBottomDialog.create();
                    mDialog.show();
                }
//                mDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
//                    @Override
//                    public void onDismiss(DialogInterface dialog) {
//                        mDialog = null;
//                    }
//                });
            } catch (Exception e) {
                LogUtils.d(Log.getStackTraceString(e));
            }
        }
    }

    public void hideWaitDialog() {
        if (mDialog != null && mDialog.isShowing() /*&& !BaseActivity.this.isFinishing()*/) {
            mDialog.dismiss();
        }
    }

    public void setAppearance(TextView v,int styleId){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            v.setTextAppearance(styleId);
        }else {
            v.setTextAppearance(this,styleId);
        }
    }

    protected void closeSoftInput(Context context){
        if (context != null) {
            InputMethodManager inputMethodManager = (InputMethodManager) context
                    .getSystemService(Context.INPUT_METHOD_SERVICE);
            if (inputMethodManager != null
                    && ((Activity) context).getCurrentFocus() != null) {
                inputMethodManager.hideSoftInputFromWindow(((Activity) context)
                                .getCurrentFocus().getWindowToken(),
                        InputMethodManager.HIDE_NOT_ALWAYS);
            }
        }
    }
    protected void showSoftInput(Context context, EditText view){
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(view,InputMethodManager.SHOW_FORCED);

    }
    private float x,y;
    @Override
    public boolean dispatchTouchEvent(MotionEvent me) {
        if (me.getAction() == MotionEvent.ACTION_UP) {  //把操作放在用户点击的时候
            View v = getCurrentFocus();      //得到当前页面的焦点,ps:有输入框的页面焦点一般会被输入框占据
            if (isShouldHideKeyboard(v, me)) { //判断用户点击的是否是输入框以外的区域
                if (v != null){
                    hideKeyboard(v.getWindowToken());   //收起键盘
                    v.clearFocus();
                }
            }
        }else if (me.getAction() == MotionEvent.ACTION_DOWN){
            x = me.getRawX();
            y = me.getRawY();
        } else if (me.getAction() == MotionEvent.ACTION_MOVE){
            if (Math.abs(me.getRawX() - x) > 50 || Math.abs(me.getRawY() - y) > 50){
                View v = getCurrentFocus();
                if (v != null){
                    hideKeyboard(v.getWindowToken());   //收起键盘
                    v.clearFocus();
                }
            }
        }
        return super.dispatchTouchEvent(me);
    }

    protected boolean isShouldHideKeyboard(View v, MotionEvent event) {
        if ((v instanceof EditText)) {  //判断得到的焦点控件是否包含EditText
            int[] l = {0, 0};
            v.getLocationInWindow(l);
            int left = l[0],    //得到输入框在屏幕中上下左右的位置
                    top = l[1],
                    bottom = top + v.getHeight(),
                    right = left + v.getWidth();
            // 点击位置如果是EditText的区域，忽略它，不收起键盘。
            return !(event.getX() > left) || !(event.getX() < right)
                    || !(event.getY() > top) || !(event.getY() < bottom);
        }
        // 如果焦点不是EditText则忽略
        return false;
    }

    public boolean isClickView(View v, MotionEvent event){
        if(v == null){
            return false;
        }
        int[] l = {0, 0};
        v.getLocationInWindow(l);
        int left = l[0],
                top = l[1],
                bottom = top + v.getHeight(),
                right = left + v.getWidth();

        return (event.getX() > left) && (event.getX() < right)
                && (event.getY() > top) && (event.getY() < bottom);
    }

    /**
     * 获取InputMethodManager，隐藏软键盘
     * @param token
     */
    public void hideKeyboard(IBinder token) {
        if (token != null) {
            InputMethodManager im = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            im.hideSoftInputFromWindow(token, InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    public int bottomMargin(){
        int navigationH = getNavigationBarHeight(this);
        if (navigationH > 1){
            return ScreenUtil.dip2px(20);
        }
        return ScreenUtil.dip2px(30);
    }

    public static int getNavigationBarHeight(Context context) {
        int navigationBarHeight = -1;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height","dimen", "android");
        if (resourceId > 0) {
            navigationBarHeight = resources.getDimensionPixelSize(resourceId);
        }
        return navigationBarHeight;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        hideWaitDialog();
        mDialog = null;
    }

    public final String getRS(int resId, Object... formatArgs){
        if (resId == -1){
            return "";
        }
        try {
            return getString(resId, formatArgs);
        }catch (IllegalFormatConversionException | UnknownFormatConversionException e){
            e.printStackTrace();
        }
        return "";
    }

    public boolean booleanExtra(String key){
        try {
            return getIntent().getBooleanExtra(key, false);
        }catch (Exception e){

        }
        return false;
    }
    public int intExtra(String key,int defaultValue){
        try {
            return getIntent().getIntExtra(key, defaultValue);
        }catch (Exception e){
            e.printStackTrace();
        }
        return defaultValue;
    }

    public String stringExtra(String key){
        try {
            return getIntent().getStringExtra(key);
        }catch (Exception e){

        }
        return "";
    }

    public boolean isKeyboardShowing(){
        Rect r = new Rect();
        View decorView = getWindow().getDecorView();
        // getWindowVisibleDisplayFrame()会返回窗口的可见区域高度
        decorView.getWindowVisibleDisplayFrame(r);
        //如果屏幕高度和Window可见区域高度差值大于整个屏幕高度的1/3，则表示软键盘显示中，否则软键盘为隐藏状态。
        int displayHeight = r.bottom - r.top;
        int screenHeight = decorView.getHeight();
        return (double) displayHeight / screenHeight < 0.7;
    }
}
