package com.transsion.xuanniao.account.comm.mvpbase;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;

//import android.support.v4.graphics.ColorUtils;


public class StatusBarUtil {
    public static int FAKE_STATUS_BAR_VIEW_ID = android.R.id.statusBarBackground;
    public static void setStatusBarColor(Activity activity, int statusBarColor, int navigationBarColor){
        //5.0以上版本直接设置状态栏颜色透明度
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            activity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            activity.getWindow().setStatusBarColor(activity.getResources().getColor(statusBarColor));//calculateStatusColor(color, statusBarAlpha)
            //4.4-5.0版本通过伪装一个状态栏来设置颜色和透明度
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            activity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            ViewGroup decorView = (ViewGroup) activity.getWindow().getDecorView();
            View fakeStatusBarView = decorView.findViewById(FAKE_STATUS_BAR_VIEW_ID);
            if (fakeStatusBarView != null) {
                if (fakeStatusBarView.getVisibility() == View.GONE) {
                    fakeStatusBarView.setVisibility(View.VISIBLE);
                }
                fakeStatusBarView.setBackgroundColor(activity.getResources().getColor(statusBarColor));
            } else {
                decorView.addView(createStatusBarView(activity, statusBarColor));
            }
            setRootView(activity);
        }
        int ui = activity.getWindow().getDecorView().getSystemUiVisibility();
        if (isLightColor(activity.getResources().getColor(statusBarColor))){//设置状态栏颜色
            ui |= View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
        }else {
            ui &= ~View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
        }

        activity.getWindow().setNavigationBarColor(activity.getResources().getColor(navigationBarColor));
        if (isLightColor(activity.getResources().getColor(navigationBarColor))){//设置底部导航栏颜色
            ui |= View.SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR;// 黑色
        }else {
            ui &= ~ View.SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR;//白色
        }

        activity.getWindow().getDecorView().setSystemUiVisibility(ui);
    }

    private static View createStatusBarView(Activity activity, int color){
        View statusBarView = new View(activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                getStatusBarHeight(activity));
        statusBarView.setLayoutParams(params);
        statusBarView.setBackgroundColor(activity.getResources().getColor(color));
        statusBarView.setId(FAKE_STATUS_BAR_VIEW_ID);
        return statusBarView;
    }

    private static int getStatusBarHeight(Context context){
        // 获得状态栏高度
        int resourceId =
                context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    private static void setRootView(Activity activity){
        ViewGroup parent = activity.findViewById(android.R.id.content);
        int i = 0;
        int count = parent.getChildCount();
        while (i < count) {
            View childView = parent.getChildAt(i);
            if (childView instanceof ViewGroup) {
                childView.setFitsSystemWindows(true);
                ((ViewGroup) childView).setClipToPadding(true);
            }
            i++;
        }
    }

    /**
     * 判断颜色是否偏亮色
     * @param color
     * @return
     */
//    public static boolean isLightColor(int color) {
//        return  ColorUtils.calculateLuminance(color) > 0.5;
//    }

    /**
     * 判断颜色是否偏亮色
     * @param color
     * @return
     */
    private static boolean isLightColor(int color) {
        double darkness = 1 - (0.299 * Color.red(color) + 0.587 * Color.green(color) + 0.114 * Color.blue(color)) / 255;
        if (darkness < 0.5) {
            return true; // It's a light color
        } else {
            return false; // It's a dark color
        }
    }
}
