package com.transsion.xuanniao.account.comm.net;


import android.os.Handler;
import android.os.Looper;

/**
 * @Description:
 * @author： HuNan on 2020/5/19
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class GlobalHandler {
    private Handler handler;
    private GlobalHandler(){
        handler = new Handler(Looper.getMainLooper());
    }
    public static class SingletonInnerHolder {
        static GlobalHandler instance = new GlobalHandler();
    }

    public static GlobalHandler getInstance(){
        return SingletonInnerHolder.instance;
    }

    public void runInMain(Runnable runnable){
        handler.post(runnable);
    }

    public void postDelay(Runnable runnable,long delay){
        handler.postDelayed(runnable, delay);
    }
}
