package com.transsion.xuanniao.account.comm.net;

import android.content.Context;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.mvpbase.BaseData;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.model.data.ApplyKeyReq;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;
import com.transsion.xuanniao.account.model.data.EncryptRes;
import com.transsion.xuanniao.account.model.data.LoginRes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

/**
 * @Description:
 * @author： HuNan on 2020/5/20
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public abstract class NetCallBack <T> implements Callback {
    private String tag;
    private Class<T> cl;
    private Context context;
    public static ArrayList<String> encryptFilter = new ArrayList<>();
    private CipherHelper cipherHelper;

    private int tokenCount = 0,keyCount = 0,timeErrorCount = 0;

    static {
        encryptFilter.add(UrlFactory.LOGIN_BY_PWD_CAPTCHA_CRYPT);
        encryptFilter.add(UrlFactory.ACCOUNT_GET_CRYPT);
        encryptFilter.add(UrlFactory.ACCOUNT_UPDATE_CRYPT);
        encryptFilter.add(UrlFactory.ACCOUNT_BIND_CRYPT);
        encryptFilter.add(UrlFactory.ADDRESS_LIST_CRYPT);
        encryptFilter.add(UrlFactory.ADDRESS_NEW_CRYPT);
        encryptFilter.add(UrlFactory.ADDRESS_UPDATE_CRYPT);
//        encryptFilter.add(UrlFactory.LOGIN_BY_SMS));
        encryptFilter.add(UrlFactory.LOGIN_BY_THIRD_CRYPT);
        encryptFilter.add(UrlFactory.PASSWORD_NEW_CRYPT);
        encryptFilter.add(UrlFactory.RESET_PWD_CRYPT);
        encryptFilter.add(UrlFactory.CHANGE_PWD_CRYPT);
        encryptFilter.add(UrlFactory.CHECK_PWD_CRYPT);
        encryptFilter.add(UrlFactory.VERIFY_CODE_CRYPT);
        encryptFilter.add(UrlFactory.PATH_ACCESS_TOKEN_CRYPT);
    }
    public NetCallBack(Context context,String tag, Class<T> cl) {
        this.tag = tag;
        this.cl = cl;
        this.context = context;
    }

    public NetCallBack(Context context,Class<T> cl) {
        this.cl = cl;
        this.context = context;
    }

    @Override
    public void onFailure(Call call, IOException e) {
        LogUtils.d( call.request().url() + "onFailure IOException response ----->" + e);
        e.printStackTrace();
        BaseData data = new BaseData();
        if (e instanceof java.net.SocketTimeoutException) {
            data.code = NetworkConstants.STATUS_NETWORK_UNAVAILABLE;
            data.message = getContext().getString(R.string.xn_request_timeout);
            postFailed(data);
        }else {
            data.code = NetworkConstants.STATUS_NETWORK_UNAVAILABLE;
            data.message = getContext().getString(R.string.xn_net_unavailable);
            postFailed(data);
        }
    }

    @Override
    public void onResponse(Call call, Response response) throws IOException {
        try {
            LogUtils.d("onResponse code ----->" + response.code());
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                if (jsonString == null || "".equals(jsonString)){
                    LogUtils.d(call.request().url() + " response -----> null" );
                    postSuccess(null);
                }else {
//                    LogUtils.d( call.request().url() + " response ----->" + jsonString);
                    LogUtils.d( call.request().url() + " response -----> success");
                    Gson gson = new Gson();
                    boolean isTeeEnable = TeeManager.instance().isTeeEnable();
                    boolean isEncrypt = isEncrypt(call.request().url().toString());
                    if (isTeeEnable && isEncrypt){
                        EncryptRes encryptRes = gson.fromJson(jsonString, EncryptRes.class);
                        if (encryptRes.checkSign()){
                            jsonString = encryptRes.dataJson(cipherHelper);
//                            LogUtils.d( call.request().url() + " response ----->" + jsonString);
                            LogUtils.d(  " response -----> checkSign success");
                            if (!encryptRes.isSafe(jsonString,cipherHelper.getVerifyId())){
                                LogUtils.d(  " response -----> not safe");
                                BaseData data = gson.fromJson(jsonString, BaseData.class);
                                data.message = getContext().getString(R.string.xn_net_unavailable);
                                postFailed(data);
                                return;
                            }
//                            LogUtils.d(  " response ----->" + jsonString);
                        }else {
                            BaseData data = gson.fromJson(jsonString, BaseData.class);
                            data.message = getContext().getString(R.string.xn_net_unavailable);
                            postFailed(data);
                            return;
                        }
                    } else {
                        LogUtils.d(  " response -----> noSign " + isTeeEnable + " " + isEncrypt);
                    }
                    T result = gson.fromJson(jsonString, cl);
                    postSuccess(result);
                }
            }else if (response.code() == NetworkConstants.ERROR_PARAM){
                String jsonString = response.body().string();
                LogUtils.d( call.request().url() + " response -----> error param" + response.code() + jsonString);
                Gson gson = new Gson();
                BaseData data = gson.fromJson(jsonString, BaseData.class);
                if (data.code == NetworkConstants.SIGN_KEY_ERROR){
                    applyKey();
                }else if (data.code == NetworkConstants.SIGN_VERIFY_TIME_FAIL){
                    if (data.errorExtend != null){
                        timeErrorCount ++;
                        long diff = data.errorExtend.currentTime - System.currentTimeMillis();
                        if (Math.abs(diff) <= CloudConfigRes.getValidPeriod(context)){
                            diff = 0;
                        }
                        ClientPrefs prefs = ClientPrefs.get(getContext());
                        prefs.setTimeDiff(diff);
                        prefs.save();
                        postRetry();
                        if (timeErrorCount > 1){
                            data.message = getContext().getString(R.string.xn_net_unavailable);
                            postFailed(data);
                            timeErrorCount = 0;
                        }
                    }
                }else {
//                    data.message = getContext().getString(R.string.xn_net_unavailable);
                    postFailed(data);
                }
            }else if (response.code() == NetworkConstants.TOKEN_TIME_OUT){
                String jsonString = response.body().string();
                LogUtils.d( call.request().url() + " response ----->" + response.code() + jsonString);
                refreshToken();
            }else{
                String jsonString = response.body().string();
                Gson gson = new Gson();
                BaseData data = gson.fromJson(jsonString, BaseData.class);
                data.message = getContext().getString(R.string.xn_net_unavailable);
                LogUtils.d( call.request().url() + " response ----->" + jsonString);
                postFailed(data);
            }
        }catch (Exception e){
            e.printStackTrace();
            LogUtils.d( call.request().url() + "Exception response ----->" + e.getMessage());
            BaseData data = new BaseData();
            data.code = response.code();
            data.message = getContext().getString(R.string.xn_net_unavailable);
            postFailed(data);
        }
    }

    public void postFailed(final BaseData data){
        if (canCallback()){
            GlobalHandler.getInstance().runInMain(new Runnable() {
                @Override
                public void run() {
                    LogUtils.d("postFailed");
                    onFailed(data,tag);
                }
            });
        }
    }

    public void postSuccess(final T result){
        if (canCallback()){
            GlobalHandler.getInstance().runInMain(new Runnable() {
                @Override
                public void run() {
                    onSuccess(NetworkConstants.STATUS_NETWORK_OK,result, tag);
                }
            });
        }
    }

    private void postRetry(){
        if (canCallback()){
            GlobalHandler.getInstance().runInMain(new Runnable() {
                @Override
                public void run() {
                    onRetry();
                }
            });
        }
    }
    private boolean canCallback(){
        if (context == null){
            return false;
        }
        if (context instanceof BaseActivity){
            if(((BaseActivity) context).isFinishing()){
                return false;
            }
        }
        return true;
    }
    private void postLogin(){

    }
    public abstract void onSuccess(int code, T result, String tag);
    public  abstract void onRetry();
    public void onFailed(BaseData data, String tag) {
        if (context instanceof BaseActivity){
            ((BaseActivity) context).hideWaitDialog();
            if (!TextUtils.isEmpty(data.message)) ((BaseActivity) context).warning(data.message);
        }
    }


    private Context getContext(){
        return context;
    }

    private void refreshToken(){
        if (tokenCount >= 3){
            return;
        }
        tokenCount ++;
        LogUtils.d( " refreshToken");
        HashMap<String,Object> params = new HashMap<>();
        params.put("refreshToken", TeeManager.instance().getRefreshToken());
//        params.put("token",ClientPrefs.get(context).getToken());
        NetWorkProxy proxy = new NetWorkProxy(context);
        Response response = proxy.requestSyncPost(UrlFactory.LOGIN_REFRESH,params);
        try {
            if (response.isSuccessful()){
                String jsonString = response.body().string();
                LogUtils.d( " refreshToken -----> isSuccessful");
                Gson gson = new Gson();
                LoginRes.SdkToken data = gson.fromJson(jsonString, LoginRes.SdkToken.class);
                TeeManager.instance().saveToken(data.accessToken, data.refreshToken);

                ClientPrefs prefs = ClientPrefs.get(context);
                prefs.setRefreshTime(System.currentTimeMillis());  // 记录刷新时间
                prefs.save();

//                TeeManager.instance().saveRefreshToken(data.refreshToken);
                postRetry();
            }else if (response.code() == NetworkConstants.ERROR_PARAM){
                String jsonString = response.body().string();
                LogUtils.d( " refreshToken -----> ERROR_PARAM" + jsonString);
                Gson gson = new Gson();
                BaseData data = gson.fromJson(jsonString, BaseData.class);
                LogUtils.d( " refreshToken -----> data.code " + data.code);
                if (data.code == NetworkConstants.NEED_TO_LOGIN){
                    postLogin();
                }else {
                    postFailed(data);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            BaseData data = new BaseData();
            data.code = response.code();
            data.message = getContext().getString(R.string.xn_net_unavailable);
            postFailed(data);
            LogUtils.d( " refreshToken ----->" + e.getMessage());
        }
    }

    private void applyKey(){
        if (keyCount >= 3){
            return;
        }
        keyCount ++;
        ApplyKeyReq params = new ApplyKeyReq();
        params.publicKey1061 = TeeManager.instance().exportSignatureKey(context);
        params.keyId = TeeManager.instance().genKeyId(context);
        params.deviceId = Utils.getDeviceId(context);
//        params.keyAdd = KeyManager.instance().keyAdd(context);
        NetWorkProxy proxy = new NetWorkProxy(context);
        Response response = proxy.requestSyncPost(UrlFactory.APPLY_KEY,params);
        try {
            if (response.isSuccessful()){
                LogUtils.d( "applyKey -----> isSuccessful");
                postRetry();
            }else if (response.code() == NetworkConstants.ERROR_PARAM){
                String jsonString = response.body().string();
                LogUtils.d( " applyKey -----> ERROR_PARAM" + jsonString);
                Gson gson = new Gson();
                BaseData data = gson.fromJson(jsonString, BaseData.class);
                LogUtils.d( " applyKey -----> data.code " + data.code);
                postFailed(data);
            }
        }catch (Exception e){
            e.printStackTrace();
            BaseData data = new BaseData();
            data.code = response.code();
            data.message = getContext().getString(R.string.xn_net_unavailable);
            postFailed(data);
            LogUtils.d( " applyKey ----->" + e.getMessage());
        }
    }

    public Class<T> getCl() {
        return cl;
    }

    public String getTag() {
        return tag;
    }

    private boolean isEncrypt(String url){
        for (int i = 0; i < encryptFilter.size(); i++) {
            if (url.contains(encryptFilter.get(i))){
                return true;
            }
        }
        return false;
    }

    public CipherHelper getCipherHelper() {
        return cipherHelper;
    }

    public void setCipherHelper(CipherHelper cipherHelper) {
        this.cipherHelper = cipherHelper;
    }
}
