package com.transsion.xuanniao.account.comm.net;

import android.content.Context;
import android.util.Log;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseData;
import com.transsion.xuanniao.account.comm.utils.LogUtils;

import java.util.HashMap;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class NetClient {
    private final String TAG = "NetWorkProxy";
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");

    public NetClient() {

    }

    /**
     * 异步请求
     * @param url
     * @param params
     * @param callback
     */
    public void requestAsyncPost(Context context,String url, Object params, Callback callback) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(url);
            String requestParams = "";
            if (params != null) {
                Gson gson = new Gson();
                requestParams = gson.toJson(params);
            }
//            LogUtils.d( "requestParams: "+url+"  "+requestParams);
            RequestBody body = RequestBody.create(MEDIA_TYPE_JSON, requestParams);
            requestBuilder.post(body);
            Call call = OkHttpFactory.getOkHttpClient(context).newCall(requestBuilder.build());
            call.enqueue(callback);
        } catch (Exception e) {
            if (callback instanceof NetCallBack){
                NetCallBack netCallBack = (NetCallBack) callback;
                handleException(context, netCallBack);
            }
            Log.e(TAG, Log.getStackTraceString(e));
        }
    }

    private void handleException(Context context,NetCallBack netCallBack){
        BaseData data = new BaseData();
        data.code = NetworkConstants.STATUS_NETWORK_UNAVAILABLE;
        data.message = context.getString(R.string.xn_net_unavailable);
        netCallBack.postFailed(data);
    }

    public void requestAsyncPost(Context context, String url, Object params, HashMap<String,String> queryParams,Callback callback) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(buildUrl(url, queryParams));

            String requestParams = "";
            if (params != null) {
                Gson gson = new Gson();
                requestParams = gson.toJson(params);
            }
//            Log.d(TAG, "requestParams: "+requestParams);
            RequestBody body = RequestBody.create(MEDIA_TYPE_JSON, requestParams);
            requestBuilder.post(body);
            Call call = OkHttpFactory.getOkHttpClient(context).newCall(requestBuilder.build());
            call.enqueue(callback);
        } catch (Exception e) {
            if (callback instanceof NetCallBack){
                NetCallBack netCallBack = (NetCallBack) callback;
                handleException(context, netCallBack);
            }
            Log.e(TAG, Log.getStackTraceString(e));
        }
    }

    private String buildUrl(String url, HashMap<String,String> queryParams){
        if (queryParams != null && queryParams.size() > 0){
            StringBuilder buffer = new StringBuilder(url);
            buffer.append("?");
            for (String key : queryParams.keySet()) {
                buffer.append(key).append("=").append(queryParams.get(key)).append("&");
            }
            url = buffer.toString().substring(0, buffer.length()-1);
        }
        
        return url;
    }
    /**
     * 同步请求，注意放到线程中
     * @param url
     * @param params
     * @return
     */
    public Response requestSyncPost(Context context,String url, Object params) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(url);
            String requestParams = "";
            if (params != null) {
                Gson gson = new Gson();
                requestParams = gson.toJson(params);
            }
//            Log.d(TAG, "requestParams: "+requestParams);
            RequestBody body = RequestBody.create(MEDIA_TYPE_JSON, requestParams);
            requestBuilder.post(body);
            Call call = OkHttpFactory.getOkHttpClient(context).newCall(requestBuilder.build());
            return call.execute();
        } catch (Exception e) {
            Log.e(TAG, Log.getStackTraceString(e));
        }
        return null;
    }

    public void requestAsyncGet(Context context, String url, HashMap<String,String> queryParams,Callback callback){
        try {
            Request.Builder requestBuilder = new Request.Builder().url(buildUrl(url, queryParams));

            Call call = OkHttpFactory.getOkHttpClient(context).newCall(requestBuilder.build());
            call.enqueue(callback);
        }catch (Exception e){
            if (callback instanceof NetCallBack){
                NetCallBack netCallBack = (NetCallBack) callback;
                handleException(context, netCallBack);
            }
            Log.e(TAG, Log.getStackTraceString(e));
        }
    }

    public Response requestSyncGet(Context context,String url, HashMap<String,String> queryParams){
        try {
            Request.Builder requestBuilder = new Request.Builder().url(buildUrl(url, queryParams));

            Call call = OkHttpFactory.getOkHttpClient(context).newCall(requestBuilder.build());
            return call.execute();
        }catch (Exception e){
            Log.e(TAG, Log.getStackTraceString(e));
        }
        return null;
    }
}
