package com.transsion.xuanniao.account.comm.net;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.constant.GlobalConstant;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.mvpbase.BaseData;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

/**
 * @Description:
 * @author： HuNan on 2020/5/19
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class NetWorkProxy {
    private static final String TAG = "NetWorkProxy";
    private Context context;
    public NetWorkProxy(Context context) {
        this.context = context;
    }

    public <T> void requestPost(String api, Object params, NetCallBack<T> callBack){
//        Gson gson = new Gson();
//        LogUtils.d(api+":" + gson.toJson(params));
        if (NetUtils.instance().isNetworkConnected(context)){
            NetClient client = new NetClient();
            client.requestAsyncPost(context, UrlFactory.getUrl(api),params,callBack);
        }else {
            if (context instanceof BaseActivity){
                ((BaseActivity) context).hideWaitDialog();
            }
            if (context instanceof Activity) {
                NetUtils.instance().showSetNet(context);
            }
        }
    }

    public Response requestSyncPost(String api, Object params){
        if (NetUtils.instance().isNetworkConnected(context)){
            NetClient client = new NetClient();
            return client.requestSyncPost(context, UrlFactory.getUrl(api),params);
        }else {
            if (context instanceof Activity) {
                NetUtils.instance().showSetNet(context);
            }
        }
        return null;
    }

    public <T> void requestPost(String api, Object params, HashMap<String,String> queryParams,NetCallBack<T> callBack){
        if (NetUtils.instance().isNetworkConnected(context)){
            NetClient client = new NetClient();
            client.requestAsyncPost(context, UrlFactory.getUrl(api),params,queryParams,callBack);
        }else {
            if (context instanceof BaseActivity){
                ((BaseActivity) context).hideWaitDialog();
            }
            if (context instanceof Activity) {
                NetUtils.instance().showSetNet(context);
            }
        }

    }
    public <T> void requestGet(String api,HashMap<String,String> queryParams,NetCallBack<T> callBack){
        if (NetUtils.instance().isNetworkConnected(context)){
            NetClient client = new NetClient();
            client.requestAsyncGet(context, UrlFactory.getUrl(api),queryParams,callBack);
        }else {
            if (context instanceof BaseActivity){
                ((BaseActivity) context).hideWaitDialog();
            }
            if (context instanceof Activity) {
                NetUtils.instance().showSetNet(context);
            }
        }

    }

    public Response requestSyncGet(String api, HashMap<String,String> queryParams){
        if (NetUtils.instance().isNetworkConnected(context)){
            NetClient client = new NetClient();
            return client.requestSyncGet(context, UrlFactory.getUrl(api),queryParams);
        }else {
            if (context instanceof Activity) {
                NetUtils.instance().showSetNet(context);
            }
        }
        return null;
    }
}
