package com.transsion.xuanniao.account.comm.net;

import android.content.Context;
import android.text.TextUtils;

import com.transsion.xuanniao.account.api.EnvMode;
import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;

import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import tech.palm.lib.utils.CloudUtils;

public class OkHttpFactory {

    private static volatile OkHttpFactory sInstance;
    private OkHttpClient client;

    private static final int CONNECT_TIMEOUT = 30;
    private static final int READ_TIMEOUT = 30;
    private Context context;
    private HashMap<String,String> heads;
    private OkHttpFactory(Context context) {
        this.context = context.getApplicationContext();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();

        builder.connectTimeout(CONNECT_TIMEOUT, TimeUnit.SECONDS)
                .readTimeout(READ_TIMEOUT, TimeUnit.SECONDS)
                .addInterceptor(getInterceptor());//配置
//        if (XNApiManager.instance().getEnvMode() != EnvMode.ONLINE){
//            builder.sslSocketFactory(SSLSocketClient.getSSLSocketFactory())//配置
//                    .hostnameVerifier(SSLSocketClient.getHostnameVerifier());
//        }
        client = builder.build();

    }
    public void setContent(Context context){
        this.context = context.getApplicationContext();
    }
    public static OkHttpFactory getInstance(Context context) {
        if (sInstance == null) {
            synchronized (OkHttpFactory.class) {
                if (sInstance == null) {
                    sInstance = new OkHttpFactory(context);
                }
            }
        }
        sInstance.setContent(context);
        return sInstance;
    }

    public static OkHttpClient getOkHttpClient(Context context) {
        return getInstance(context).client;
    }

    private Interceptor getInterceptor() {

        return new Interceptor() {
            @Override
            public Response intercept(Chain chain) throws IOException {
                Request request = chain.request();
                Request.Builder builder = request.newBuilder();

                HttpUrl url = request.url().newBuilder()
//                        .addQueryParameter("category", XNApiManager.instance().getCategory())
                        .build();

                String token = TeeManager.instance().getToken();
                if (TextUtils.isEmpty(token)) {
                    LogUtils.d("OkHttp addHeader token is empty");  // for快速排除问题
                }

                Request newRequest = builder
                        .addHeader("Req-ID", UUID.randomUUID().toString())
                        .addHeader("Client-ID", XNApiManager.instance().getClientId())
                        .addHeader("Device-ID", Utils.getDeviceId(context))
                        .addHeader("Client-Data", Utils.params(context))
                        .addHeader("Timestamp", String.valueOf(System.currentTimeMillis()))
                        .addHeader("Authorization", "Bearer "+ token)
                        .addHeader("Version-ID", CloudConfigRes.getVersion(context))
                        .url(url)
                        .build();
//                LogUtils.d(newRequest.headers().toString());
                return chain.proceed(newRequest);
            }
        };
    }

    public HashMap<String, String> getHeads() {
        return heads;
    }

    public void setHeads(HashMap<String, String> heads) {
        this.heads = heads;
    }
}
