package com.transsion.xuanniao.account.comm.tee;

//import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;

import java.security.spec.AlgorithmParameterSpec;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * @Description:
 * @author： 胡南 on 2021/5/21
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CipherHelper {
    private String verifyId;
    private final String algo;
    private final byte[] key;
    private final byte[] iv;

    public CipherHelper(String algo, byte[] key, byte[] iv) {
        this.algo = algo;
        this.key = key;
        this.iv = iv;
    }

    public CipherHelper(String algo, String hexKey, String hexIV) {
        this.algo = algo;
        this.key = fromHex(hexKey);
        this.iv = fromHex(hexIV);
    }

    public static CipherHelper init() {
        return new CipherHelper("AES/CBC/PKCS5Padding", "d3808864c571656c77dc794e36fbecf4", "36ee63f993bddcf25162ec14f89a0859");
    }

    private static int fromHex(char c) {
        if (c >= 'a' && c <= 'f') {
            return (c - 'a') + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return (c - 'A') + 10;
        }
        if (c >= '0' && c <= '9') {
            return (c - '0');
        }
        throw new IllegalArgumentException("must be hex!");
    }

    public static byte[] fromHex(String hex) {
        if (hex == null) {
            return null;
        }

        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("length must be even!");
        }

        byte[] bin = new byte[hex.length() / 2];
        for (int i = 0; i < bin.length; i++) {
            bin[i] = (byte) ((fromHex(hex.charAt(i * 2)) << 4) | (fromHex(hex.charAt(i * 2 + 1))));
        }

        return bin;
    }

    public byte[] encrypt(final byte[] data) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.key, "AES");
            AlgorithmParameterSpec iv = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(algo);
            cipher.init(Cipher.ENCRYPT_MODE, key, iv);
            return cipher.doFinal(data);
        } catch (final Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public String encryptAndBase64(final byte[] data){
        try {
            SecretKeySpec key = new SecretKeySpec(this.key, "AES");
            AlgorithmParameterSpec iv = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(algo);
            cipher.init(Cipher.ENCRYPT_MODE, key, iv);
            return RSAEncryptUtil.base64Encode(cipher.doFinal(data));
        } catch (final Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }


    public byte[] decrypt(final byte[] data) {
        try {
//            LogUtils.d("Decrypt key:"+RSAEncryptUtil.base64Encode(this.key));
//            LogUtils.d("Decrypt iv:"+RSAEncryptUtil.base64Encode(this.iv));
            SecretKeySpec key = new SecretKeySpec(this.key, "AES");
            AlgorithmParameterSpec iv = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(algo);
            cipher.init(Cipher.DECRYPT_MODE, key, iv);
            return cipher.doFinal(data);
        } catch (final Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public byte[] encrypt(final String data) throws Exception {
        return encrypt(data.getBytes("utf-8"));
    }

    public byte[] requestKey(){
        byte[] request = new byte[key.length+iv.length];
        System.arraycopy(key, 0, request, 0, key.length);
        System.arraycopy(iv, 0, request, key.length, iv.length);
//        LogUtils.d("requestKey key:"+RSAEncryptUtil.base64Encode(this.key));
        return request;
    }

    public String getVerifyId() {
        return verifyId;
    }

    public void setVerifyId(String verifyId) {
        this.verifyId = verifyId;
    }
}