package com.transsion.xuanniao.account.comm.tee;

import android.content.Context;

import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import com.transsion.xuanniao.account.comm.utils.Sha256Utils;

import java.util.List;

import com.transsion.security.api.hap.TranCryptoManagerLite;
import hyperion.hap.ICryptoManager;

/**
 * @Description:
 * @author： 胡南 on 2021/5/17
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class LiteKeyManager {
    public final String signatureAlias1031 = "signatureAliasTemp";
    public final String signatureAlias = "signatureAlias";
//    private final String encryptAlias = "encryptAlias";
    public final int signatureType = 1061;
    public final int signatureType1031 = 1031;
//    private final int encryptType = 1021;
//    private boolean needConfig = true;
    private LiteKeyManager(){

    }

    static class SingletonInnerHolder {
        public static LiteKeyManager instance = new LiteKeyManager();
    }

    public static LiteKeyManager instance(){
        return SingletonInnerHolder.instance;
    }

    public boolean isAliasNotExist(Context context) {
        List<String> aliases = getCryptoManager(context).aliases();
        return aliases == null || !aliases.contains(signatureAlias);
    }

    public void generateSignatureKey(Context context){
//        config(context);
        getCryptoManager(context).generateKey(signatureAlias,signatureType);
        LogUtils.d("generateSignatureKey");
    }

    public String exportSignatureKey(Context context){
//        config(context);
        byte[] key = getCryptoManager(context).exportKey(signatureAlias);
        if (isAliasNotExist(context)){
            generateSignatureKey(context);
            key = getCryptoManager(context).exportKey(signatureAlias);
        }
        if (key != null){
            return RSAEncryptUtil.base64Encode(key);
        }

        return "";
    }

    public String genKeyId(Context context) {
        byte[] key = getCryptoManager(context).exportKey(signatureAlias);
        if (isAliasNotExist(context)){
            generateSignatureKey(context);
            key = getCryptoManager(context).exportKey(signatureAlias);
        }
        if (key != null) {
            return Sha256Utils.getSha256FromBytes(key);
        }
        return "";
    }


//    public String keyAdd(Context context){
//        config(context);
//        return RSAEncryptUtil.base64Encode(CryptoManager.Companion.getInstance(context).getImportKeyAAD());
//    }

//    public synchronized void config(Context context){
//        if (needConfig){
//            try {
//                HapConfig.Companion.getInstance(context).configure("kFGe62OfE+23bZ7vYO9P2kgwRgIhAJxlIwtMjrKhwmXk7XkwRQAZJ6cPPb/cm7lJstQEXiGzAiEA\n" +
//                        "+fgnGJpSIUl8zBWz1y0aNdlc6/dCvEzis9g/ULSOJ02U6B/TKk75J+3bP/3/Dps5XhgxSxMA71Oc\n" +
//                        "cMaso2qnFs7RCy0UbTC7UnmM3mA7ZLok+SjZw5cG5xbVr8Niu9oj8H4SdLo1e382cSVwgeh3Shne\n" +
//                        "IWgGvSKyTQgHte/LbEsydUBta+mzRi1pb6db9qKU2EEc/kTXyzgVwAPxO/JKi7IuldOFMQ==");
//            }catch (IllegalAccessError e){
//                e.printStackTrace();
//            }
//        }
//        needConfig = false;
//    }

    private ICryptoManager getCryptoManager(Context context){
        return TranCryptoManagerLite.Companion.getInstance(context.getApplicationContext());
    }
}