package com.transsion.xuanniao.account.comm.tee;

import android.content.Context;

import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;

import com.transsion.security.api.hap.TranStoreManagerLite;
import hyperion.hap.ICryptoManager;
import com.transsion.security.api.hap.TranCryptoManagerLite;

/**
 * 使用Tee加密缓存数据
 */
public class LiteTeeStoreManager implements IStoreManager {
    private final Context context;

    public LiteTeeStoreManager(Context ctx) {
        context = ctx;
    }

    @Override
    public void saveString(String key, String value) {
//        LiteKeyManager.instance().config(context);
        getStoreManager(context).saveString(key, value);
    }

    @Override
    public void saveStringPersist(String key, String value) {
//        LiteKeyManager.instance().config(context);
        getStoreManager(context).saveStringPersist(key, value);
    }

    @Override
    public String loadString(String key) {
//        LiteKeyManager.instance().config(context);
        return getStoreManager(context).loadString(key);
    }

    @Override
    public String sign(Context context, byte[] value) {
//        LiteKeyManager.instance().config(context);
        byte[] sign = getCryptoManager(context).sign(LiteKeyManager.instance().signatureAlias, value);
        if (sign != null) {
            return RSAEncryptUtil.base64Encode(sign);
        }
        return "";
    }

    @Override
    public String genKeyId(Context context) {
        return LiteKeyManager.instance().genKeyId(context);
    }

    @Override
    public String exportSignatureKey(Context context) {
        return LiteKeyManager.instance().exportSignatureKey(context);
    }

    private ICryptoManager getCryptoManager(Context context) {
        return TranCryptoManagerLite.Companion.getInstance(context.getApplicationContext());
    }

    private hyperion.hap.IStoreManager getStoreManager(Context context) {
        return TranStoreManagerLite.Companion.getInstance(context.getApplicationContext());
    }
}
