package com.transsion.xuanniao.account.comm.tee;

import android.content.Context;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.transsion.palmsdk.PalmID;
import com.transsion.xuanniao.account.comm.constant.PalmsKeys;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.model.data.AccountRes;
import com.transsion.xuanniao.account.model.data.Config;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

/**
 * @Description:
 * @author： 胡南 on 2021/5/6
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class TeeManager {
    private final String KEY_ACCOUNT = "account";
    private final String KEY_OTHER_OPEN_ID = "other_open_id";
    private final String KEY_CONFIG = "config";
    private final String KEY_IS_KEY_UPLOADED = "isKeyUploaded";
    private final String KEY_FINGERPRINT = "fingerprint";
    private CipherHelper cipherHelper;
    private IStoreManager storeManager;
    private boolean isTeeEnable = false;

    private TeeManager() {
        Context context = PalmID.getContext();
        if (context != null) {
//            storeManager = new SpStoreManager(context);
            storeManager = new LiteTeeStoreManager(context);
            isTeeEnable = true;
        }
    }

    public void setStoreManager(IStoreManager manager) {
        storeManager = manager;
    }

    public void setTeeEnable(boolean enable) {
        isTeeEnable = enable;
    }

    public boolean isTeeEnable() {
        return isTeeEnable;
    }

    public CipherHelper generateCipher() {
        if (cipherHelper == null) {
            byte[] iv = new byte[16];
            SecureRandom sRandom = new SecureRandom();
            sRandom.nextBytes(iv);
            cipherHelper = new CipherHelper("AES/CBC/PKCS5Padding", generateKey(), iv);
        }
        return cipherHelper;
    }

    public byte[] generateKey() {
        try {
            SecretKey secretKey = KeyGenerator.getInstance("AES").generateKey();
            return secretKey.getEncoded();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void clearAccount(Context context) {
        if (storeManager != null) {
            storeManager.saveString(KEY_ACCOUNT, "");
        }
    }

    static class SingletonInnerHolder {
        static TeeManager instance = new TeeManager();
    }

    public static TeeManager instance() {
        return SingletonInnerHolder.instance;
    }

    public void saveAccountInfo(AccountRes accountRes) {
        if (accountRes != null) {
            if (storeManager != null) {
                storeManager.saveString(KEY_ACCOUNT, new Gson().toJson(accountRes));
            }
        }
    }

    public AccountRes getAccountInfo() {
        if (storeManager != null) {
            String account = storeManager.loadString(KEY_ACCOUNT);
            if (!TextUtils.isEmpty(account)) {
                AccountRes accountRes = new Gson().fromJson(account, AccountRes.class);
                return accountRes;
            }
        }
        return null;
    }

    public String getOtherOpenId(){
        if (storeManager != null){
            String otherOpenId = storeManager.loadString(KEY_OTHER_OPEN_ID);
            if (!TextUtils.isEmpty(otherOpenId)){
                return otherOpenId;
            }
        }
        return "0";
    }

    public void saveOtherOpenId(String openId){
        if (!TextUtils.isEmpty(openId)){
            storeManager.saveString(KEY_OTHER_OPEN_ID, openId);
        }
    }

    public void saveToken(String token, String refreshToken) {
        Config config = getConfig();
        if (config == null) {
            config = new Config();
        }
        config.token = token;
        config.refreshToken = refreshToken;
        if (storeManager != null) {
            storeManager.saveString(KEY_CONFIG, new Gson().toJson(config));
        }
    }

//    public void saveRefreshToken(String refreshToken) {
//        Config config = getConfig();
//        if (config == null) {
//            config = new Config();
//        }
//        config.refreshToken = refreshToken;
//        if (storeManager != null) {
//            storeManager.saveString(KEY_CONFIG, new Gson().toJson(config));
//        }
//    }

    public String getToken() {
        Config config = getConfig();
        if (config != null) {
            return config.token;
        }
        return "";
    }

    public String getRefreshToken() {
        Config config = getConfig();
        if (config != null) {
            return config.refreshToken;
        }
        return "";
    }

    public void saveKeyUploaded(boolean isKeyUploaded) {
        if (storeManager != null) {
            storeManager.saveString(KEY_IS_KEY_UPLOADED, isKeyUploaded ? "true" : "false");
        }
    }

//    public void saveConfig(Config config) {
//        if (storeManager != null) {
//            storeManager.saveString(KEY_CONFIG, new Gson().toJson(config));
//        }
//    }

    public Config getConfig() {
        if (storeManager != null) {
            String data = storeManager.loadString(KEY_CONFIG);
            if (!TextUtils.isEmpty(data)) {
                return new Gson().fromJson(data, Config.class);
            }
        }
        return null;
    }

    public void saveFingerprint(Context context,String fingerprint){
        if (storeManager != null){
            storeManager.saveString(KEY_FINGERPRINT,fingerprint);
        }
    }

    public String getFingerprint(Context context){
        if (storeManager != null){
            return storeManager.loadString(KEY_FINGERPRINT);
        }
        return "";
    }

//    public void saveAccountIdPersist(Context context, String accountId) {
//        if (storeManager != null) {
//            storeManager.saveStringPersist(KEY_ACCOUNT_ID, accountId);
//        }
//    }

    public boolean getIsKeyUploaded() {
        Config config = getConfig();
        if (config != null) {
            return config.isKeyUploaded
                    || "true".equals(storeManager.loadString(KEY_IS_KEY_UPLOADED));
        } else {
            if (storeManager != null) {
                return "true".equals(storeManager.loadString(KEY_IS_KEY_UPLOADED));
            }
        }
        return false;
    }

    public String getLinkedBrandId() {
        String linkedBrandId = null;
        if (storeManager != null) {
            linkedBrandId = storeManager.loadString(PalmsKeys.EXTRA_LINKED_BD);
        }
        return linkedBrandId;
    }

    public String sign(Context context, byte[] value) {
        if (storeManager != null) {
            return storeManager.sign(context, value);
        }
        return "";
    }

    public String genKeyId(Context context) {
        if (storeManager != null) {
            return storeManager.genKeyId(context);
        }
        return "";
    }

    public String exportSignatureKey(Context context) {
        if (storeManager != null) {
            return storeManager.exportSignatureKey(context);
        }
        return null;
    }
}