package com.transsion.xuanniao.account.comm.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.util.Log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.List;

/**
 * @Description:
 * @author： 胡南 on 2020/10/23
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class FileUtil {
    public static void grantCropUriPermission(Context context, Uri uri, Intent intent) {
//        if (Build.VERSION.SDK_INT >= 30) {
        try {
            List<ResolveInfo> resInfoList = context.getPackageManager().queryIntentActivities(intent,
                    PackageManager.MATCH_DEFAULT_ONLY);
            if (resInfoList.isEmpty()) {
                return;
            }
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                context.grantUriPermission(packageName, uri, Intent.FLAG_GRANT_WRITE_URI_PERMISSION
                        | Intent.FLAG_GRANT_READ_URI_PERMISSION);
            }
        } catch (Exception e) {
            LogUtils.d(Log.getStackTraceString(e));
        }
//        }
    }

    public static void deleteDirWithFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory())
            return;
        for (File file : dir.listFiles()) {
            if (file.isFile())
                file.delete(); // 删除所有文件
            else if (file.isDirectory())
                deleteDirWithFile(file); // 递规的方式删除文件夹
        }
        dir.delete();// 删除目录本身
    }

    public static String readTxtFile(String strFilePath) {
        StringBuilder content = new StringBuilder();
        File file = new File(strFilePath);
        if (file.isDirectory()) {
            LogUtils.d(strFilePath + ",The File doesn't not exist.");
        } else {
            try {
                InputStream inputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader buffReader = new BufferedReader(inputStreamReader);
                String line;
                while (( line = buffReader.readLine()) != null) {
                    content.append(line);
                }
                inputStream.close();
            } catch (java.io.FileNotFoundException e) {
                LogUtils.d(strFilePath + ",The File doesn't not exist.");
            } catch (IOException e) {
                LogUtils.d(e.getMessage());
            }
        }
        return content.toString();
    }

    public static void writeTxtToFile(String strContent, String filePath, String fileName) {
        //生成文件夹以后，再生成文件，否则会出错
        makeFilePath(filePath, fileName);

        String strFilePath = filePath + "/"+fileName;

        try {
            File file = new File(strFilePath);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            raf.setLength(0);
            raf.write(strContent.getBytes());
            raf.close();
        } catch (Exception e) {
            LogUtils.d("Error on write File:" + e);
        }
    }

    // 生成文件
    public static File makeFilePath(String filePath, String fileName) {
        File file = null;
        makeRootDirectory(filePath);
        try {
            file = new File(filePath + fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    // 生成文件夹
    public static void makeRootDirectory(String filePath) {
        File file = null;
        try {
            file = new File(filePath);
            if (!file.exists()) {
                file.mkdir();
            }
        } catch (Exception e) {
            LogUtils.d(e + "");
        }
    }
}
