package com.transsion.xuanniao.account.comm.widget;

import android.os.SystemClock;
import android.util.Log;
import android.view.View;


// app use
public abstract class CustomClickListener implements View.OnClickListener {
    private Long mLastClickTime = 0L;
    private Long timeInterval = 1000L;

    @Override
    public void onClick(View v) {
        long nowTime = SystemClock.elapsedRealtime();
        if (nowTime - mLastClickTime > timeInterval) {
            // 单次点击事件
            onSingleClick(v);
            mLastClickTime = nowTime;
        }
        // 快速点击事件
        onFastClick(v);
    }

    public abstract void onSingleClick(View v);
    public void onFastClick(View v){
        Log.d("CustomClickListener","onFastClick");
    }
}