package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.text.BidiFormatter;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.transsion.core.utils.ScreenUtil;
import com.transsion.xuanniao.account.R;


/**
 * @Description:
 * @author： HuNan on 2020/6/18
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class PhoneInput extends FrameLayout {
    private EditText edit;
    private TextView cc;
    private IPhoneInputListener inputListener;
    private EditFocus editFocus;
    private BidiFormatter bidiFormatter;
    public PhoneInput(Context context) {
        super(context);
    }

    public PhoneInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.xn_phone_input, this, true);
        initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        initView();
    }

    private void initAttr(TypedArray array){
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = findViewById(R.id.line);
        lineView.setVisibility(showLine ? View.VISIBLE : INVISIBLE);
        edit = findViewById(R.id.edit);
        if (hint != null && !hint.isEmpty()){
            edit.setHint(hint);
        }
        int maxLength= array.getInteger(R.styleable.InputView_max_length, -1);
        if (maxLength >= 0){
            edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
        array.recycle();
    }

    private void initView(){
        bidiFormatter = BidiFormatter.getInstance();
        edit = findViewById(R.id.edit);
        edit.addTextChangedListener(new Watch());
        cc = findViewById(R.id.cc);
//        cc.setPaintFlags(cc.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
        cc.setOnClickListener(new Click());
        edit.setOnFocusChangeListener(new FocusListener());
    }

    public String getText(){
        return edit.getText().toString();
    }
    public void setCc(String text){
        cc.setText(bidiFormatter.unicodeWrap(text, TextDirectionHeuristics.LTR));
        if (TextUtils.isEmpty(text)||TextUtils.isEmpty(text.trim())) {
            return;
        }
        switch (text.trim().length()) {
            case 2:
                cc.setPadding(ScreenUtil.dip2px(16), 0, ScreenUtil.dip2px(10),  0);
                break;
            case 3:
                cc.setPadding(ScreenUtil.dip2px(10), 0, ScreenUtil.dip2px(8),  0);
                break;
            case 4:
                cc.setPadding(ScreenUtil.dip2px(5), 0, ScreenUtil.dip2px(4),  0);
                break;
            case 5:
                cc.setPadding(ScreenUtil.dip2px(1), 0, ScreenUtil.dip2px(0),  0);
                break;
        }
    }
    public String getCc(){
        return cc.getText().toString();
    }
    public void setText(String text){
        edit.setText(text);
        Editable b = edit.getText();
        edit.setSelection(b.length());
    }
    public void setPhoneAndCC(String value){
        if (value != null && value.contains("-")){
            String[] ss = value.split("-");
            if (ss.length == 2){
                setText(ss[1]);
                setCc("+"+ss[0]);
            }
        }
    }
    public void addWatch(TextWatcher watcher){
        edit.addTextChangedListener(watcher);
    }

    public void setInputListener(IPhoneInputListener inputListener) {
        this.inputListener = inputListener;
    }

    public void setEditFocus(EditFocus editFocus) {
        this.editFocus = editFocus;
    }

    public boolean haveFocus(){
        if (edit != null){
            return edit.isFocusable();
        }
        return false;
    }

    public EditText getEdit() {
        return edit;
    }

    class Watch implements TextWatcher{
        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {

        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {

        }

        @Override
        public void afterTextChanged(Editable s) {

        }
    }

    class Click extends CustomClickListener{
        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.cc){
                if (inputListener != null){
                    inputListener.onSelectCc();
                }
            }
        }
    }
    class  FocusListener implements OnFocusChangeListener{
        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            View line = findViewById(R.id.line);
            View ccLine = findViewById(R.id.ccLine);
            int colorId = hasFocus ? R.color.xn_line_s : R.color.os_gray_secondary_color;
            line.setBackgroundColor(getResources().getColor(colorId));
            ccLine.setBackgroundColor(getResources().getColor(colorId));
            if (editFocus != null){
                editFocus.onFocusChange(v, hasFocus);
            }
            cc.setTextAppearance(hasFocus ? R.style.font_black_14 : R.style.font_black_14_t40);
        }
    }

    public interface IPhoneInputListener{
        void onSelectCc();
    }

    public interface EditFocus {
        void onFocusChange(View v, boolean hasFocus);
    }
}
