package com.transsion.xuanniao.account.comm.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.CountDownTimer;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;

import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;

/**
 * @Description:
 * @author： HuNan on 2020/6/18
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class SmsCodeInput extends FrameLayout {
    private long millisInFuture = 100 * 1000;
    private long countDownInterval = 1000;
    private EditText smsEdit;
    private TextView getCode;
    private CountDownTimer countDownTimer;
    private ISmsCodeListener smsCodeListener;
    private boolean isCounting = false;
    private boolean isFirst = true;

    private EditFocus editFocus;
    public SmsCodeInput(Context context) {
        super(context);
    }

    public SmsCodeInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.xn_view_sms_input, this, true);
        initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        millisInFuture = CloudConfigRes.getCount(context) * 1000;
        initView();
    }

    private void initAttr(TypedArray array) {
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = findViewById(R.id.smsLine);
        lineView.setVisibility(showLine ? View.VISIBLE : INVISIBLE);
        if (hint != null && !hint.isEmpty()) {
            EditText phoneEdit = findViewById(R.id.edit);
            phoneEdit.setHint(hint);
        }
        array.recycle();
    }

    private void initView() {
        smsEdit = findViewById(R.id.smsEdit);
        smsEdit.setOnFocusChangeListener(new FocusListener());
        getCode = findViewById(R.id.getCode);
        getCode.setOnClickListener(new Click());
    }

    public String getText() {
        return smsEdit.getText().toString();
    }

    public void setText(String value) {
        smsEdit.setText(value);
    }

    public boolean isCounting() {
        return isCounting;
    }

    public void startCount() {
        isFirst = false;
        isCounting = true;
        smsEdit.requestFocus();
        if (countDownTimer == null) {
            countDownTimer = new CountDownTimer(millisInFuture, countDownInterval) {
                @SuppressLint("StringFormatInvalid")
                @Override
                public void onTick(long millisUntilFinished) {
                    getCode.setText(getContext().getString(R.string.xn_resend_code, millisUntilFinished / 1000));
                }

                @Override
                public void onFinish() {
                    isCounting = false;
                    if (smsCodeListener != null) {
                        smsCodeListener.countFinish();
                    }
                }
            };
        }
        countDownTimer.start();
    }

    private String second(long value) {
        return String.valueOf(value / 1000);
    }

    public void startByEnd(long value){
        if (value + millisInFuture > System.currentTimeMillis()){
            setMillisInFuture(value + millisInFuture - System.currentTimeMillis());
            setGetCodeEnable(false);
            startCount();
        }
    }
    public void clearCount() {
        if (countDownTimer != null) {
            countDownTimer.cancel();
            countDownTimer = null;
        }
        millisInFuture = CloudConfigRes.getCount(getContext()) * 1000;
    }

    public void setGetCodeEnable(boolean enable) {
        getCode.setEnabled(enable);
        if (enable) {
            setAppearance(getCode, R.style.font_get_code_medium);
            getCode.setText(getContext().getString(isFirst ? R.string.xn_get_code : R.string.xn_resend));
        } else {
            if (!isCounting){
                getCode.setText(getContext().getString(isFirst ? R.string.xn_get_code : R.string.xn_resend));
            }
            setAppearance(getCode, R.style.font_get_code_disable_medium);
        }
    }

    public void warning(String text) {
        Toast toast = Toast.makeText(getContext(), text, Toast.LENGTH_LONG);
        toast.setGravity(Gravity.CENTER, 0, 0);
        toast.show();
    }


    public void addWatch(TextWatcher watcher) {
        smsEdit.addTextChangedListener(watcher);
    }

    public long getMillisInFuture() {
        return millisInFuture;
    }

    public void setMillisInFuture(long millisInFuture) {
        this.millisInFuture = millisInFuture;
    }

    public long getCountDownInterval() {
        return countDownInterval;
    }

    public void setCountDownInterval(long countDownInterval) {
        this.countDownInterval = countDownInterval;
    }

    public void setSmsCodeListener(ISmsCodeListener smsCodeListener) {
        this.smsCodeListener = smsCodeListener;
    }

    public void setAppearance(TextView v, int styleId) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            v.setTextAppearance(styleId);
        } else {
            v.setTextAppearance(getContext(), styleId);
        }
    }

    public EditFocus getEditFocus() {
        return editFocus;
    }

    public void setEditFocus(EditFocus editFocus) {
        this.editFocus = editFocus;
    }

    public EditText getEdit() {
        return smsEdit;
    }

    public void setError(boolean error) {
        View line = findViewById(R.id.smsLine);
        if (error) {
            line.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.os_red_basic_color));
        } else {
            line.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.os_gray_secondary_color));
        }
    }

    class Click extends CustomClickListener{
        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.getCode) {
                if (smsCodeListener != null) {
                    smsCodeListener.getCode();
                }
            }
        }
    }

    class FocusListener implements OnFocusChangeListener {
        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            View line = findViewById(R.id.smsLine);
            int colorId = hasFocus ? R.color.xn_line_s : R.color.os_gray_secondary_color;
            line.setBackgroundColor(getResources().getColor(colorId));
            AppCompatImageView smsLogo = findViewById(R.id.smsLogo);
            Drawable drawable = smsLogo.getDrawable();
            drawable.setTint(getResources().getColor(hasFocus ? R.color.xn_input_logo_color_s : R.color.xn_input_logo_color, null));
            if (editFocus != null){
                editFocus.onFocusChange(v, hasFocus);
            }
        }
    }

    public interface ISmsCodeListener {
        void getCode();

        void countFinish();
    }

    public interface EditFocus{
        void onFocusChange(View v, boolean hasFocus);
    }
}
