package com.transsion.xuanniao.account.comm.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.transsion.xuanniao.account.R;


public class WaitDialog extends Dialog {
	private String msg;
	private Context context;
	private Animation animation;
	private ImageView circleImg;
	private TextView content;
	public WaitDialog(Context context) {
		super(context, R.style.waitDialog);
		this.context = context;
	}
	public WaitDialog(Context context, int theme){
		super(context, theme);
		this.context = context;
	}
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		this.setContentView(R.layout.xn_wait_dialog);
		circleImg = (ImageView) findViewById(R.id.circleImg);
		animation = AnimationUtils.loadAnimation(context, R.anim.wait_rotate);
		circleImg.setAnimation(animation);
		content = (TextView) findViewById(R.id.content);
		if (msg != null) content.setText(msg);
		setCanceledOnTouchOutside(false);
	}

	private void showAnimation(){
    	circleImg.setAnimation(animation);
		if (msg != null) content.setText(msg);
    }

	@Override
	public void show() {
		super.show();
		showAnimation();
	}
	public void show(String msg){
		this.msg = msg;
		content.setText(msg);
		show();
	}
	@Override
	public void dismiss() {
		super.dismiss();
		circleImg.clearAnimation();
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}
}