package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.graphics.Color;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.transsion.widgetslib.util.Utils;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.LogUtils;

/**
 * @Description:
 * @author： 胡南 on 2021/7/6
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class XNLinkMovementMethod extends LinkMovementMethod {

    private static LinkMovementMethod sInstance;

    public static LinkMovementMethod getInstance() {
        if (sInstance == null)
            sInstance = new XNLinkMovementMethod();

        return sInstance;
    }

    @Override
    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {

        int action = event.getAction();
        if (action == MotionEvent.ACTION_UP ||
                action == MotionEvent.ACTION_DOWN ||
                action == MotionEvent.ACTION_MOVE ||
                action == MotionEvent.ACTION_CANCEL) {
            int x = (int) event.getX();
            int y = (int) event.getY();

            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();

            x += widget.getScrollX();
            y += widget.getScrollY();

            Layout layout = widget.getLayout();
            int line = layout.getLineForVertical(y);
            int off = layout.getOffsetForHorizontal(line, x);

            ClickableSpan[] link = buffer.getSpans(off, off, ClickableSpan.class);

            if (link.length != 0) {
                if (action == MotionEvent.ACTION_UP) {
                    link[0].onClick(widget);
                    cancelClickEffect(widget, buffer);
                } else if (action == MotionEvent.ACTION_DOWN
                        || action == MotionEvent.ACTION_MOVE) {

                    int color = 0;
                    try {
                        Context context = widget.getContext();
                        TypedValue typedValue = new TypedValue();
                        if (context.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
                            color = ContextCompat.getColor(context, typedValue.resourceId);
                        }
                    } catch (Exception e) {
                        color = ContextCompat.getColor(widget.getContext(), R.color.xn_link_color_dis);
                    }
                    try {
                        buffer.setSpan(new ForegroundColorSpan(color),
                                buffer.getSpanStart(link[0]), buffer.getSpanEnd(link[0]),
                                Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    } catch (Exception e) {
                        LogUtils.d(Log.getStackTraceString(e));
                    }
                }else {
                    cancelClickEffect(widget, buffer);
                }
                return true;
            } else {
                cancelClickEffect(widget, buffer);
            }
        }
        return false;
    }

    private void cancelClickEffect(TextView widget,Spannable buffer){
        ClickableSpan[] links = buffer.getSpans(0, buffer.length(), ClickableSpan.class);
        int color = 0;
        try {
            color = Utils.getOsPlatformBasicColor(widget.getContext());
        } catch (Throwable e) {
            color = ContextCompat.getColor(widget.getContext(), R.color.xn_link_color);
        }
        try {
            for (int i = 0; i < links.length; i++) {
                buffer.setSpan(new ForegroundColorSpan(color),
                        buffer.getSpanStart(links[i]), buffer.getSpanEnd(links[i]),
                        Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            }
        } catch (Exception e) {
            LogUtils.d(Log.getStackTraceString(e));
        }
        Selection.removeSelection(buffer);
    }
}
