package com.transsion.xuanniao.account.help.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ConsoleMessage;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.constant.DataKeys;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.utils.AppUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.comm.utils.OSUtils;
import com.transsion.xuanniao.account.comm.widget.NoWifiPage;
import com.transsion.xuanniao.account.login.view.LoginActivity;
import com.transsion.xuanniao.account.login.view.PrivacyNoNetDialog;

import tech.palm.lib.athena.AthenaImpl;

/**
 * @Description:
 * @author： 胡南 on 2021/5/11
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class WebViewActivity extends BaseActivity {
    private WebView mWebView;
    private PrivacyNoNetDialog noNetDialog;
    private String url;
    private ProgressBar mProgressBar;
    private NoWifiPage noWifiPage;

    /**
     * 兼容系统应用无法使用webview
     */
    public static void startActivity(Context context, int titleId, String url) {
        try {
            if (AppUtils.isSystemApp(context)) {
                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                context.startActivity(intent);
            } else {
                Intent intent = new Intent(context, WebViewActivity.class);
                intent.putExtra(DataKeys.TITLE, titleId);
                intent.putExtra(DataKeys.URL, url);
                context.startActivity(intent);
            }
        } catch (Exception e) {
            LogUtils.d(Log.getStackTraceString(e));
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.xn_activity_web_view);
        url = getIntent().getStringExtra(DataKeys.URL);
        mProgressBar = findViewById(R.id.progress_bar);
        initActionBar();
        initWebView();
    }

    @Override
    protected void onResume() {
        super.onResume();
        showNoWifiPage();
    }

    private void showNoWifiPage(){
        if (!NetUtils.instance().isNetworkConnected(this)){
            if (noWifiPage == null){
                noWifiPage = new NoWifiPage(this);
                noWifiPage.setReload(new NoWifiPage.Reload() {
                    @Override
                    public void onReload() {
                        if (NetUtils.instance().isNetworkConnected(WebViewActivity.this)){
                            noWifiPage.dismiss(WebViewActivity.this);
                            if (!TextUtils.isEmpty(url)){
                                mWebView.loadUrl(url);
                            }
                        }
                    }
                });
            }
            noWifiPage.show(this);
            if (noNetDialog == null){
                noNetDialog = new PrivacyNoNetDialog(this, new PrivacyNoNetDialog.PrivacyNoNetClick() {
                    @Override
                    public void onPositiveClick() {

                    }
                });
            }
            if (!noNetDialog.isShow()){
                if (getIntent().getBooleanExtra(DataKeys.IS_FAQ, false)){
                    AthenaImpl.getInstance(this).hcNetworkInvalidShow();
                }else {
                    AthenaImpl.getInstance(this).pcNetworkInvalidShow();
                }

                noNetDialog.show(url);
            }
        }else {
            if (noWifiPage != null) noWifiPage.dismiss(this);
            if (noNetDialog != null) noNetDialog.dismiss();
        }
    }

    private void initActionBar(){
        int titleId = getIntent().getIntExtra(DataKeys.TITLE,-1);
        if (titleId != -1){
            getActionBar().setTitle(getString(titleId));
        }
        getActionBar().setDisplayHomeAsUpEnabled(true);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK){
            if (mWebView.canGoBack()){
                mWebView.goBack();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                finish();
                break;
        }
        return super.onOptionsItemSelected(item);
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void initWebView(){
        mWebView = findViewById(R.id.webView);
        WebSettings webSettings = mWebView.getSettings();

        //设置自适应屏幕
        webSettings.setUseWideViewPort(true); //将图片调整到适合webview的大小
        webSettings.setLoadWithOverviewMode(true); // 缩放至屏幕的大小
        //缩放操作
        webSettings.setSupportZoom(true); //支持缩放，默认为true。是下面那个的前提。
        webSettings.setBuiltInZoomControls(true); //设置内置的缩放控件
        webSettings.setDisplayZoomControls(false); //隐藏原生的缩放控件
        webSettings.setCacheMode(WebSettings.LOAD_CACHE_ELSE_NETWORK); //关闭webview中缓存
        webSettings.setAllowFileAccess(true); //设置可以访问文件
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true); //支持通过JS打开新窗口
        webSettings.setLoadsImagesAutomatically(true); //支持自动加载图片
        webSettings.setJavaScriptEnabled(true);
        webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        webSettings.setDomStorageEnabled(true);
        mWebView.setWebViewClient(new WebViewClient(){
            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (!TextUtils.isEmpty(url)){
                    if (url.contains("policy.html")){
                        getActionBar().setTitle(getString(R.string.xn_privacy_policy));
                    }else if (url.contains("terms.html")){
                        getActionBar().setTitle(getString(R.string.xn_user_agreement));
                    }
                }
            }
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                view.loadUrl(request.getUrl().toString());
                return true;
            }
            @Override
            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                LogUtils.d("onReceivedSslError");
                handler.cancel();
            }
        });
        mWebView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress == 100) {
                    mProgressBar.setVisibility(View.GONE);
                } else {
                    mProgressBar.setVisibility(View.VISIBLE);
                    mProgressBar.setProgress(newProgress);
                }
            }

            @Override
            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                switch (consoleMessage.messageLevel()){
                    case ERROR://将error信息上报到服务端
                        LogUtils.d("webview=="+consoleMessage.message()+" level="+ consoleMessage.messageLevel());
                        break;

                }
                return super.onConsoleMessage(consoleMessage);
            }
        });
        if (!TextUtils.isEmpty(url)){
            mWebView.loadUrl(url);
        }
    }

    @Override
    protected void onDestroy() {
        if(mWebView!=null){
            ViewParent parent = mWebView.getParent();
            if (parent != null) {
                ((ViewGroup) parent).removeView(mWebView);
            }
            mWebView.stopLoading();
            mWebView.removeAllViews();
            mWebView.destroy();
        }
        super.onDestroy();
    }
}