package com.transsion.xuanniao.account.login.presenter;

import android.graphics.Bitmap;

import com.transsion.xuanniao.account.comm.mvpbase.IView;
import com.transsion.xuanniao.account.model.data.AccountRes;
import com.transsion.xuanniao.account.model.data.BehaviorRes;
import com.transsion.xuanniao.account.model.data.BehaviorVerifyRes;
import com.transsion.xuanniao.account.model.data.LoginRes;
import com.transsion.xuanniao.account.model.data.PolicyRes;

/**
 * @Description:
 * @author： 胡南 on 2021/4/20
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public interface ILoginView extends IView {
    void showCaptcha(String captchaCode,String captchaBase64);

    String getAccount();

    String getImageCaptcha();

    String getVerificationCode();

    int getType();

    void acquireCodeSuccess();

    String getPwd();

    void displayCaptchaCodeInput();

    void loginSuccess(String eventType, LoginRes result);

    void showAcquireCodeDayLimit();

    void showCodeError();

    void byCodeShowCaptchaError();

    void byPwdShowCaptchaError();

    void showPwdError();

    boolean isImageCaptchaVisible();

    void getPoliceSuccess(PolicyRes result, String tag);

    void saveAccount(AccountRes account);

    void showFiveLimitError(boolean show, long millisUntilFinished);
    void showFrozenError(long endTime);

    void showCodeHelpTips();

    void showCaptchaLimitError(boolean show, long millisUntilFinished);

    void showAcquireCodeMonthLimit();

    void showCaptchaReduction();

    void showPhoneCode();

    void updateVerifyView();

    void getBehaviorResult(BehaviorRes behaviorRes, boolean showImage);

    void verifyBehaviorResult(BehaviorVerifyRes verifyRes, int code);
}
