package com.transsion.xuanniao.account.login.presenter;


import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.constant.GlobalConstant;
import com.transsion.xuanniao.account.comm.mvpbase.BaseData;
import com.transsion.xuanniao.account.comm.mvpbase.BasePresenter;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.net.NetworkConstants;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.AthenaUtils;
import com.transsion.xuanniao.account.comm.utils.BitmapUtils;
import com.transsion.xuanniao.account.comm.utils.LanguageUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import com.transsion.xuanniao.account.comm.widget.CountHelper;
import com.transsion.xuanniao.account.login.view.LoginActivity;
import com.transsion.xuanniao.account.model.IApplyKeyMode;
import com.transsion.xuanniao.account.model.ICloudConfigMode;
import com.transsion.xuanniao.account.model.ICountryModel;
import com.transsion.xuanniao.account.model.ILoginMode;
import com.transsion.xuanniao.account.model.IVerificationModel;
import com.transsion.xuanniao.account.model.data.AccountRes;
import com.transsion.xuanniao.account.model.data.AcquireCodeReq;
import com.transsion.xuanniao.account.model.data.AcquireCodeRes;
import com.transsion.xuanniao.account.model.data.ApplyKeyReq;
import com.transsion.xuanniao.account.model.data.BehaviorReq;
import com.transsion.xuanniao.account.model.data.BehaviorRes;
import com.transsion.xuanniao.account.model.data.BehaviorVerifyRes;
import com.transsion.xuanniao.account.model.data.CaptchaRes;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;
import com.transsion.xuanniao.account.model.data.CountryData;
import com.transsion.xuanniao.account.model.data.Key;
import com.transsion.xuanniao.account.model.data.LoginByCodeReq;
import com.transsion.xuanniao.account.model.data.LoginCaptchaReq;
import com.transsion.xuanniao.account.model.data.LoginRes;
import com.transsion.xuanniao.account.model.data.PolicyRes;
import com.transsion.xuanniao.account.model.impl.AboutMode;
import com.transsion.xuanniao.account.model.impl.ApplyKeyMode;
import com.transsion.xuanniao.account.model.impl.CloudConfigMode;
import com.transsion.xuanniao.account.model.impl.CountryModel;
import com.transsion.xuanniao.account.model.impl.LoginMode;
import com.transsion.xuanniao.account.model.impl.VerificationModel;

import tech.palm.lib.athena.AthenaImpl;

//import com.google.android.setupcompat.util.WizardManagerHelper;

/**
 * @Description:
 * @author： 胡南 on 2021/4/20
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class LoginPresenter extends BasePresenter<ILoginView> {
    public final String TAG_USAGE = "usage";
    public final String TAG_POLICY = "Policy";
    public final String TAG_GET_CODE = "getCode";
    private final String TAG_LOGIN = "login";
    public final String TYPE_IMAGE = "IMAGE";
    public final String TYPE_BEHAVIOR = "BEHAVIOR";
    private boolean isLoginByCode = true;
    private String countryCode;
    private String countryName;
    private IVerificationModel verificationModel;
    private ILoginMode loginMode;
    private String imageTicket,codeCaptchaCode,pwdCaptchaCode;
    private String verificationType = TYPE_BEHAVIOR;
    private boolean isFinish;
//    private PolicyRes policyRes;
    private boolean codeNeedCaptcha;
    private int acquireCaptchaCount = 0;
    private CountHelper pwdCountHelper;
    private CountHelper captchaHelper;
    private ICloudConfigMode cloudConfigMode;
    private boolean isLoginTimeout;
    private int smsCnt = 0;
    private int picCnt = 0;
    private int emsCnt = 0;
    private int retryCnt = 0;
    private long loginStart;
    private CountryData countryData;
    public LoginPresenter(){
        verificationModel = new VerificationModel(GlobalConstant.SCENE_LOGIN);
        loginMode = new LoginMode();
    }

    public void getCountriesFromCache(){
        ICountryModel countryModel = new CountryModel();
        countryModel.getCountriesFromCash(activity(), new NetCallBack<CountryData>(activity(),CountryData.class) {
            @Override
            public void onSuccess(int code, CountryData result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                countryData = result;
                if (countryData != null){
                    getIView().showPhoneCode();
                }
            }

            @Override
            public void onRetry() {

            }
        });
    }

    public void getCloudConfig(){
        if (!isViewAttached()){
            return;
        }
        if (!NetUtils.instance().isNetworkConnected(activity())){
            return;
        }
        if (cloudConfigMode == null){
            cloudConfigMode = new CloudConfigMode();
        }
        cloudConfigMode.getCloudConfig(activity(), new NetCallBack<CloudConfigRes>(activity(),CloudConfigRes.class) {
            @Override
            public void onSuccess(int code, CloudConfigRes result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                if (result != null && result.cloudClientConfigs != null){
                    result.timeStamp = System.currentTimeMillis();
                    long diff = result.sysTime - System.currentTimeMillis();
                    if (Math.abs(diff) <= result.validPeriod){
                        diff = 0;
                    }
                    String cloudConfig = new Gson().toJson(result);
                    ClientPrefs prefs = ClientPrefs.get(activity());
                    for (CloudConfigRes.ConfigItem configItem : result.cloudClientConfigs) {
                        if (configItem != null
                                && configItem.type == CloudConfigRes.TYPE_PRIVACY_UPDATE) {
                            if (configItem.configMap != null){
                                String privacyVersion = String.valueOf(configItem.configMap.get("privacyVersion"));
                                String userAgreementVersion = String.valueOf(configItem.configMap.get("userAgreementVersion"));
                                prefs.setPrivacyVersion(privacyVersion);
                                prefs.setUserAgreementVersion(userAgreementVersion);
                            }
                        }
                    }
                    prefs.setCloudConfig(cloudConfig);
                    prefs.setTimeDiff(diff);
                    prefs.save();
                    AthenaImpl.getInstance(activity()).remoteConfigReceived(cloudConfig);
                }
            }

            @Override
            public void onRetry() {

            }
        });
    }
    public void applyKey(String tag){
        if (!isViewAttached()){
            return;
        }
        IApplyKeyMode applyKeyMode = new ApplyKeyMode();
        ApplyKeyReq applyKeyReq = new ApplyKeyReq();
        applyKeyReq.publicKey1061 = TeeManager.instance().exportSignatureKey(activity());
        applyKeyReq.keyId = TeeManager.instance().genKeyId(activity());
        applyKeyMode.applyKey(activity(), applyKeyReq, new NetCallBack<BaseData>(activity(),tag,BaseData.class) {
            @Override
            public void onSuccess(int code, BaseData result, String tag) {
                if (!isViewAttached()){
                    return;
                }
//                Config config = new Config();
//                config.isKeyUploaded = true;
//                TeeManager.instance().saveConfig(config);
                TeeManager.instance().saveKeyUploaded(true);
                if (TAG_LOGIN.equals(tag)){
                    login();
                }
            }

            @Override
            public void onRetry() {}
        });
    }

    /**
     * 获取行为验证图片数据
     * @param type 点击 or 滑动
     */
    public void getBehaviorData(String type, boolean showImage) {
        BehaviorReq behaviorReq = new BehaviorReq();
        behaviorReq.verificationType = type;
        if (showImage) {
            activity().showWaitDialog(activity().getString(R.string.xn_loading));
        }
        verificationModel.getBehaviorData(activity(), behaviorReq, new NetCallBack<BehaviorRes>(activity(),BehaviorRes.class) {
            @Override
            public void onSuccess(int code, BehaviorRes result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                if (result != null) {
                    if (showImage
                            && result.verifyCount >= result.verifyMaxCount) {  // 超过限制请求图形验证码
                        acquireCaptcha(null, true);
                    } else {
                        activity().hideWaitDialog();
                        getIView().getBehaviorResult(result, showImage);

                        Bundle param = new Bundle();
                        param.putString("type", type);
                        param.putInt("result", 0);
                        AthenaImpl.getInstance(activity())
                                .trackAccountEvent("login_behavior_verify_req", param);
                    }
                }
            }

            @Override
            public void onRetry() {
                if (!isViewAttached()){
                    return;
                }
                getBehaviorData(type, showImage);
            }

            @Override
            public void onFailed(BaseData data, String tag) {
                if (!isViewAttached()){
                    return;
                }
                activity().hideWaitDialog();
                if (data.code == NetworkConstants.CAPTCHA_FREQUENT){

                }else {
                    super.onFailed(data, tag);
                }
                Bundle param = new Bundle();
                param.putString("type", type);
                param.putInt("result", 1);
                param.putString("reason", String.valueOf(data.code));
                AthenaImpl.getInstance(activity())
                        .trackAccountEvent("login_behavior_verify_req", param);
            }
        });
    }

    /**
     * 校验行为验证坐标值
     */
    public void verifyBehavior(String type, String data, String ticket, String resId) {
        BehaviorReq behaviorReq = new BehaviorReq();
        behaviorReq.data = data;
        behaviorReq.ticket = ticket;
        verificationModel.verifyBehavior(activity(), behaviorReq, new NetCallBack<BehaviorVerifyRes>(activity(), BehaviorVerifyRes.class) {
            @Override
            public void onSuccess(int code, BehaviorVerifyRes result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                if (result != null) {
                    if (result.result) {
                        imageTicket = result.captchaTicket;  // 验证成功
                        verificationType = TYPE_BEHAVIOR;
                    }
                    getIView().verifyBehaviorResult(result, 0);

                    Bundle param = new Bundle();
                    param.putString("type", type);
                    param.putInt("result", result.result ? 1 : 0);
                    param.putString("reason", result.result ? "" : resId);  // 上传错误素材
                    AthenaImpl.getInstance(activity())
                            .trackAccountEvent("login_behavior_verify_result", param);
                }
            }

            @Override
            public void onRetry() {
                if (!isViewAttached()){
                    return;
                }
                verifyBehavior(type, data, ticket, resId);
            }

            @Override
            public void onFailed(BaseData data, String tag) {
                if (!isViewAttached()){
                    return;
                }
                if (data.code == NetworkConstants.BEHAVIOR_VERIFY_OVER_LIMIT) {
                    acquireCaptcha(null, true);
                    getIView().verifyBehaviorResult(null, data.code);
                }
                Bundle param = new Bundle();
                param.putString("type", type);
                param.putInt("result", 0);
                param.putString("reason", String.valueOf(data.code));
                AthenaImpl.getInstance(activity())
                        .trackAccountEvent("login_behavior_verify_result", param);
            }
        });
    }

//    public void acquireCaptcha(String tag){
//        if (!isViewAttached()){
//            return;
//        }
//        picCnt ++;
//        verificationModel.acquireCaptcha(activity(), new NetCallBack<CaptchaRes>(activity(),tag,CaptchaRes.class) {
//            @Override
//            public void onSuccess(int code, CaptchaRes result, String tag) {
//                if (!isViewAttached()){
//                    return;
//                }
//                activity().hideWaitDialog();
//                if (result != null) {  // 接口偶发性的返回null
//                    imageTicket = result.getCaptchaTicket();
//                    codeCaptchaCode = result.getCaptchaCode();
//                    if (isLoginByCode){
//                        codeNeedCaptcha = TextUtils.isEmpty(codeCaptchaCode);
//                    }
//
//                    if (TAG_GET_CODE.equals(tag) && isLoginByCode){//不需要显示图形验证码，则直接请求短信验证码
//                        acquireCode();
//                    }
//
//                    if (!codeNeedCaptcha){
//                        picCnt = 0;
//                    }
//                    getIView().showCaptcha(result.getCaptchaCode(),BitmapUtils.base64ToBitmap(result.getCaptchaBase64()));
//                    acquireCaptchaCount = 0;
//                }
//            }
//
//            @Override
//            public void onRetry() {
//                if (!isViewAttached()){
//                    return;
//                }
//                acquireCaptcha(tag);
//            }
//
//            @Override
//            public void onFailed(BaseData data, String tag) {
//                if (!isViewAttached()){
//                    return;
//                }
//                activity().hideWaitDialog();
//                if (!codeNeedCaptcha){
//                    picCnt = 0;
//                }
//                if (data.code == NetworkConstants.CAPTCHA_FREQUENT){
//                    if (isLoginByCode){
//                        codeNeedCaptcha = true;
//                    }
//                    if (data.errorExtend != null){
//                        ClientPrefs prefs = ClientPrefs.get(activity());
//                        prefs.setCaptchaLoginLimit(data.errorExtend.getEndTime());
//                        prefs.save();
//                        showCaptchaLimit(data.errorExtend.getEndTime());
//                    }
//                }else {
//                    super.onFailed(data, tag);
//                }
//                getIView().showCaptchaReduction();
//            }
//        });
//    }

    /**
     * 强制产生图形验证码
     */
    public void acquireCaptcha(String tag, boolean forceShow) {
        if (!isViewAttached()){
            return;
        }
        verificationModel.acquireCaptcha(activity(), forceShow, new NetCallBack<CaptchaRes>(activity(),tag,CaptchaRes.class) {
            @Override
            public void onSuccess(int code, CaptchaRes result, String tag) {
                if (!isViewAttached()){
                    return;
                }

                imageTicket = result.getCaptchaTicket();
                verificationType = TYPE_IMAGE;
//                codeCaptchaCode = result.getCaptchaCode();
                if (isLoginByCode){
                    codeNeedCaptcha = true;
                }

                if (TAG_GET_CODE.equals(tag) && isLoginByCode){//不需要显示图形验证码，则直接请求短信验证码
                    acquireCode(false);
                }else {
                    activity().hideWaitDialog();
                }

                if (!codeNeedCaptcha){
                    picCnt = 0;
                }
                getIView().showCaptcha(result.getCaptchaCode(), result.getCaptchaBase64());
                acquireCaptchaCount = 0;
            }

            @Override
            public void onRetry() {
                if (!isViewAttached()){
                    return;
                }
                acquireCaptcha(tag, forceShow);
            }

            @Override
            public void onFailed(BaseData data, String tag) {
                if (!isViewAttached()){
                    return;
                }
                activity().hideWaitDialog();
                if (!codeNeedCaptcha){
                    picCnt = 0;
                }
                if (data.code == NetworkConstants.CAPTCHA_FREQUENT){
                    if (isLoginByCode){
                        codeNeedCaptcha = true;
                    }
                    if (data.errorExtend != null){
                        ClientPrefs prefs = ClientPrefs.get(activity());
                        prefs.setCaptchaLoginLimit(data.errorExtend.getEndTime());
                        prefs.save();
                        showCaptchaLimit(data.errorExtend.getEndTime());
                    }
                }else {
                    super.onFailed(data, tag);
                }
                getIView().showCaptchaReduction();
            }
        });
    }

    public void acquireCode(boolean showWait){
        if (!isViewAttached()){
            return;
        }
        boolean isPhone = getIView().getType() == GlobalConstant.ACCOUNT_PHONE;
        smsCnt ++;
        AthenaImpl.getInstance(activity()).getSmsCl(isPhone ? "Phone" : "Mail",smsCnt);
        if (!NetUtils.instance().isNetworkConnected(activity())){
            NetUtils.instance().showSetNet(activity());
            return;
        }
        if (showWait) {
            activity().showWaitDialog(activity().getString(R.string.xn_loading));
        }

//        if (TextUtils.isEmpty(imageTicket)){
//            if (acquireCaptchaCount <= 3){
//                acquireCaptchaCount++;
//                acquireCaptcha(TAG_GET_CODE);
//            }else {
//                activity().hideWaitDialog();
//            }
//            return;
//        }
        AcquireCodeReq acquireCodeReq = new AcquireCodeReq();
        if (getIView().isImageCaptchaVisible()){
            acquireCodeReq.setCaptchaCode(getIView().getImageCaptcha());
        }else {
            acquireCodeReq.setCaptchaCode(codeCaptchaCode);
        }
        acquireCodeReq.setCaptchaTicket(imageTicket);
        if (isPhone){
            acquireCodeReq.setPhone(getCountryCode() +"-"+ getIView().getAccount());
        }else {
            acquireCodeReq.setEmail(getIView().getAccount());
            emsCnt ++;
        }
        acquireCodeReq.verificationType = verificationType;
        verificationModel.acquireCode(activity(),acquireCodeReq, new NetCallBack<AcquireCodeRes>(activity(),AcquireCodeRes.class) {
            @Override
            public void onSuccess(int code, AcquireCodeRes result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                activity().hideWaitDialog();
//                imageTicket = null;  // 重新请求图形码
//                boolean typePhone = getIView().getType() == GlobalConstant.ACCOUNT_PHONE;
                AthenaImpl.getInstance(activity()).
                        smsSentShow(isPhone ? "Phone" : "Mail");
                AthenaImpl.getInstance(activity()).getSmsResult(1, "",
                        isPhone ? "Phone" : "Mail",smsCnt);
                getIView().acquireCodeSuccess();
            }

            @Override
            public void onRetry() {
                if (!isViewAttached()){
                    return;
                }
                acquireCode(false);
            }

            @Override
            public void onFailed(BaseData data, String tag) {
                if (!isViewAttached()){
                    return;
                }
//                boolean typePhone = getIView().getType() == GlobalConstant.ACCOUNT_PHONE;
                AthenaImpl.getInstance(activity()).getSmsResult(0, String.valueOf(data.code),
                        isPhone ? "Phone" : "Mail",smsCnt);
                activity().hideWaitDialog();
                getIView().updateVerifyView();
//                acquireCaptcha(null);
                if (data.code == NetworkConstants.VERIFICATION_DAY_LIMIT){
                    AthenaImpl.getInstance(activity()).
                            smsExceedShow(isPhone ? "Phone" : "Mail");
                    getIView().showAcquireCodeDayLimit();
                }else if (data.code == NetworkConstants.VERIFICATION_MONTH_LIMIT){
                    AthenaImpl.getInstance(activity()).
                            smsExceedShow(isPhone ? "Phone" : "Mail");
                    getIView().showAcquireCodeMonthLimit();
                }else if (data.code == NetworkConstants.CAPTCHA_ERROR){
                    AthenaImpl.getInstance(activity()).picVerifyWrongShow();
                    getIView().byCodeShowCaptchaError();
                }else {
                    super.onFailed(data,tag);
                }
            }
        });
    }

    public void showFivePwdLimit(long time){
        long count = time - System.currentTimeMillis();
        if (count > 0){
            clearCount();
            pwdCountHelper = new CountHelper(new CountHelper.CountListener() {
                @Override
                public void countFinish() {
                    if (!isViewAttached()){
                        return;
                    }
                    getIView().showFiveLimitError(false,0);
                }

                @Override
                public void onTick(long millisUntilFinished) {
                    if (!isViewAttached()){
                        return;
                    }
                    getIView().showFiveLimitError(true,millisUntilFinished);
                }
            });
            pwdCountHelper.init(count);
            pwdCountHelper.startCount();
        }
    }

    public void showCaptchaLimit(long time){
        long count = time - System.currentTimeMillis();
        if (count > 0){
            clearCount();
            captchaHelper = new CountHelper(new CountHelper.CountListener() {
                @Override
                public void countFinish() {
                    if (!isViewAttached()){
                        return;
                    }
                    getIView().showCaptchaLimitError(false,0);
                }

                @Override
                public void onTick(long millisUntilFinished) {
                    if (!isViewAttached()){
                        return;
                    }
                    getIView().showCaptchaLimitError(true,millisUntilFinished);
                }
            });
            captchaHelper.init(count);
            captchaHelper.startCount();
        }
    }
    public void clearCount(){
        if (pwdCountHelper != null){
            pwdCountHelper.clearCount();
        }
        if (captchaHelper != null){
            captchaHelper.clearCount();
        }
    }

    public boolean isShowPwdLimit(){
        if (pwdCountHelper != null){
            return pwdCountHelper.isCounting();
        }
        return false;
    }

    public boolean isShowCaptchaLimit(){
        if (captchaHelper != null){
            return captchaHelper.isCounting();
        }
        return false;
    }

    public void login(){
        if (!isViewAttached()){
            return;
        }
        retryCnt ++;
        if (TeeManager.instance().isTeeEnable()) {
            if (!TeeManager.instance().getIsKeyUploaded() && NetUtils.instance().isNetworkConnected(activity())) {
                applyKey("TAG_LOGIN");
                return;
            }
        }
        if (isLoginByCode){
            loginByCode();
        }
    }

    private String loginBy(){
        return AthenaUtils.loginBy(isLoginByCode,
                getIView().getType() == GlobalConstant.ACCOUNT_PHONE,
                getIView().getType() == GlobalConstant.ACCOUNT_EMAIL);
    }

    public void smsFillEnd(){
        AthenaImpl.getInstance(activity()).smsFillEnd(getIView().getType() == GlobalConstant.ACCOUNT_PHONE ?
                "Phone" : "Mail", smsCnt);
    }

    private void loginByCode(){
        if (!isViewAttached()){
            return;
        }
        if (!NetUtils.instance().isNetworkConnected(activity())){
            NetUtils.instance().showSetNet(activity());
            AthenaImpl.getInstance(activity()).networkInvalidShow();
            return;
        }
        AthenaImpl.getInstance(activity()).loginStart(loginBy(),picCnt,smsCnt - emsCnt,emsCnt);
        activity().showWaitDialog(activity().getString(R.string.xn_loading_verify_account));

        String account;
        LoginByCodeReq loginByCodeReq = new LoginByCodeReq();
        loginByCodeReq.setExtraInfo(NetworkConstants.NEED_ACCOUNT);
        if (getIView().getType() == GlobalConstant.ACCOUNT_PHONE){
            account = getCountryCode() + "-" + getIView().getAccount();
            loginByCodeReq.setPhone(account);
        }else {
            account = getIView().getAccount();
            loginByCodeReq.setEmail(account);
        }
        loginByCodeReq.setVerificationCode(getIView().getVerificationCode());
        try {
            LogUtils.d("loginByVerificationCode");
            loginMode.loginByVerificationCode(activity(), loginByCodeReq, new NetCallBack<LoginRes>(activity(),LoginRes.class) {
                @Override
                public void onSuccess(int code, LoginRes result, String tag) {
                    if (!isViewAttached()){
                        return;
                    }
                    activity().hideWaitDialog();
                    AthenaImpl.getInstance(activity()).loginEnd(loginBy(),1,"",System.currentTimeMillis() - loginStart);
//                    AthenaImpl.getInstance(activity()).loginResult(1, "", retryCnt);
                    if (result != null && result.account != null){
                        saveToken(result, 0, account, 0);
                        getIView().saveAccount(result.account);
                        getIView().loginSuccess(result.token.eventType,result);
                    }else {
                        activity().warning(activity().getString(R.string.xn_net_unavailable));
                    }
                }

                @Override
                public void onRetry() {
                    if (!isViewAttached()){
                        return;
                    }
                    loginByCode();
                }

                @Override
                public void onFailed(BaseData data, String tag) {
                    if (!isViewAttached()){
                        return;
                    }
//                    AthenaImpl.getInstance(activity()).loginResult(0, String.valueOf(data.code), retryCnt);
                    AthenaImpl.getInstance(activity()).loginEnd(loginBy(),0,String.valueOf(data.code),System.currentTimeMillis() - loginStart);
                    activity().hideWaitDialog();
//                    acquireCaptcha(null);
                    getIView().updateVerifyView();
                    if (data.code == NetworkConstants.CAPTCHA_ERROR){
                        getIView().showCodeError();
                    }else if (data.code == NetworkConstants.VERIFICATION_VERIFY_OVER_TIMES){
                        getIView().showCodeError();
                        getIView().showCodeHelpTips();
                    }else {
                        super.onFailed(data,tag);
                    }

                }
            });
        } catch (Exception e) {
            LogUtils.d(Log.getStackTraceString(e));
            activity().hideWaitDialog();
        }
    }

    public void getPolice(String tag){
        if (!isViewAttached()){
            return;
        }
        activity().showWaitDialog(activity().getString(R.string.xn_loading));
        AboutMode aboutMode = new AboutMode();
        aboutMode.getPolicy(activity(), LanguageUtils.getLocalLanguage(activity()),getType(),
                new NetCallBack<PolicyRes>(activity(),tag,PolicyRes.class) {
            @Override
            public void onSuccess(int code, PolicyRes result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                activity().hideWaitDialog();
                getIView().getPoliceSuccess(result,tag);
            }

            @Override
            public void onRetry() {
                if (!isViewAttached()){
                    return;
                }
                getPolice(tag);
            }
        });
    }

    public boolean isFinish() {
        return isFinish;
    }

    public void setFinish(boolean finish) {
        isFinish = finish;
    }

    private void saveToken(LoginRes login, int loginType, String account, int codeType){
        ClientPrefs prefs = ClientPrefs.get(activity());
        prefs.setLastLoginReq(loginType, account, codeType);  // 记录上一次登录方式
        prefs.save();
    }
    private LoginActivity activity(){
        return (LoginActivity) getIView().getContext();
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public CountryData getCountryData() {
        return countryData;
    }

    public void setCountryData(CountryData countryData) {
        this.countryData = countryData;
    }

    public String getCountryCode() {
        if (TextUtils.isEmpty(countryCode) && countryData != null && countryData.countries != null){
            countryCode = CountryData.getCountryCode(getIView().getContext(),countryData.countries);
            countryName = ClientPrefs.get(activity()).getCountryName();
        }
        return countryCode;
    }

    public String getCountryCodeWithPlus() {
        if (TextUtils.isEmpty(countryCode) && countryData != null && countryData.countries != null){
            countryCode = CountryData.getCountryCode(getIView().getContext(),countryData.countries);
        }
        if (TextUtils.isEmpty(countryCode)){
            return countryCode;
        }
        return "+" + countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean isLoginByCode() {
        return isLoginByCode;
    }

    public void setLoginByCode(boolean loginByCode) {
        isLoginByCode = loginByCode;
    }

    public void switchLoginMode() {
        isLoginByCode = !isLoginByCode;
    }

    public String getImageTicket() {
        return imageTicket;
    }

    public boolean isCodeNeedCaptcha() {
        return codeNeedCaptcha;
    }

    public void setCodeNeedCaptcha(boolean codeNeedCaptcha) {
        this.codeNeedCaptcha = codeNeedCaptcha;
    }

    public void setLoginStart(long loginStart) {
        this.loginStart = loginStart;
    }

    private String getType(){
        if (TextUtils.equals(activity().getPackageName(), "tech.palm.id")){
            return "palmId";
        }
        return "sdk";
    }

    /**
     * 页面销毁缓存状态(切换深色模式)
     */
    public void saveState(Bundle outState) {
        outState.putString("lp_ticket", imageTicket);
        outState.putString("lp_verify_type", verificationType);
        outState.putBoolean("lp_login_code", isLoginByCode);
        outState.putBoolean("lp_code_captcha", codeNeedCaptcha);
    }

    /**
     * 页面恢复之前状态(切换深色模式)
     */
    public void restoreState(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey("lp_ticket")) {
                imageTicket = inState.getString("lp_ticket");
            }
            if (inState.containsKey("lp_verify_type")) {
                verificationType = inState.getString("lp_verify_type");
            }
            if (inState.containsKey("lp_login_code")) {
                setLoginByCode(inState.getBoolean("lp_login_code"));
            }
            if (inState.containsKey("lp_code_captcha")) {
                setCodeNeedCaptcha(inState.getBoolean("lp_code_captcha"));
            }
        }
    }
}
