package com.transsion.xuanniao.account.login.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.view.LoadingView;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.BitmapUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.OSUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import com.transsion.xuanniao.account.comm.widget.BehaviorImageView;
import com.transsion.xuanniao.account.comm.widget.BehaviorSlideView;
import com.transsion.xuanniao.account.model.data.BehaviorReq;
import com.transsion.xuanniao.account.model.data.BehaviorRes;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.UUID;

public class BehaviorVerifyDialog {

    public static final int TYPE_SINGLE = 0;
    public static final int TYPE_MULTIPLE = 1;
    public static final int TYPE_SLIDER = 2; // 行为验证类型(普通点击、依次点击、拖动滑块)
    private TextView tvTips, tvResult;  // 提示语，验证结果
    private ImageView ivRefresh;
    private View viewLoading;
    private BehaviorRes behaviorRes;
    private BehaviorImageView verifyImage;
    private BehaviorSlideView slideView;  // 滑块控件
    private Dialog promptDialog;
    private BehaviorListener behaviorListener;

    public interface BehaviorListener {
        void refreshClick();
        void startVerify(String data, String ticket, String resId);
    }

    public void show(Activity context) {
        if (promptDialog == null) {
            promptDialog = new AlertDialog.Builder(context, R.style.dialog_soft_input_center)
                    .setView(R.layout.xn_behavior_verify_dialog)
                    .create();
            promptDialog.setCanceledOnTouchOutside(false);  // 只允许点击返回键和关闭按钮
            promptDialog.show();
            promptDialog.findViewById(R.id.ivClose).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss();
                }
            });
            ivRefresh = promptDialog.findViewById(R.id.ivRefresh);
            ivRefresh.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    ObjectAnimator.ofFloat(ivRefresh, "rotation", 0, -360)
                            .setDuration(500).start();
                    viewLoading.setVisibility(View.VISIBLE);
                    if (behaviorListener != null) {
                        behaviorListener.refreshClick();
                    }
                }
            });
            viewLoading = promptDialog.findViewById(R.id.viewLoading);
            tvTips = promptDialog.findViewById(R.id.tvTips);
            tvResult = promptDialog.findViewById(R.id.tvResult);
            verifyImage = promptDialog.findViewById(R.id.verifyImage);
            verifyImage.setClickListener(new BehaviorImageView.ImageClickListener() {
                @Override
                public void onTouch(float xPos, float yPos) {
//                    LogUtils.d("onTouch xPos = " + xPos + ", yPos = " + yPos);
                    if (behaviorRes != null
                            && behaviorListener != null) {
                        try {
                            String data = new JSONArray().put(
                                    new JSONObject()
                                            .put("xPos", xPos * 100)  // 百分比
                                            .put("yPos", yPos * 100)).toString();
                            behaviorListener.startVerify(RSAEncryptUtil.encrypt(data, behaviorRes.publicKey),
                                    behaviorRes.ticket, UUID.nameUUIDFromBytes(behaviorRes.bg.getBytes()).toString());
                        } catch (Exception e) {
                            LogUtils.d(Log.getStackTraceString(e));
                        }
                    }
                }
            });
            slideView = promptDialog.findViewById(R.id.slideView);
            slideView.setSlideListener(new BehaviorSlideView.SlideListener() {
                @Override
                public void onViewSlide(float distance) {
//                    LogUtils.d("onViewSlide distance = " + distance);
                    verifyImage.setXPos(distance);
                }

                @Override
                public void onViewReleased(float xPos) {
//                    LogUtils.d("onViewReleased xPos = " + xPos);
                    if (behaviorRes != null
                            && behaviorListener != null) {
//                        viewLoading.setVisibility(View.VISIBLE);
                        slideView.setDragEnable(false);
                        try {
                            String data = new JSONArray().put(
                                    new JSONObject()
                                            .put("xPos", xPos * 100)  // 百分比
                                            .put("yPos", behaviorRes.ypos)).toString();
                            behaviorListener.startVerify(RSAEncryptUtil.encrypt(data, behaviorRes.publicKey),
                                    behaviorRes.ticket, UUID.nameUUIDFromBytes(behaviorRes.bg.getBytes()).toString());
                        } catch (Exception e) {
                            LogUtils.d(Log.getStackTraceString(e));
                        }
                    }
                }
            });
        } else {
            initView();
            if (!promptDialog.isShowing()) {
                promptDialog.show();
            }
        }
    }

    /**
     * 初始化所有控件
     */
    private void initView() {
        tvResult.setVisibility(View.GONE);
        if (verifyImage != null) {
            verifyImage.setData(-1, 0, null, null);  // 清空数据
        }
        if (slideView != null) {
            slideView.reset();
            slideView.setVisibility(View.GONE);  // 默认隐藏
        }
    }

    public void setBehaviorListener(BehaviorListener listener) {
        behaviorListener = listener;
    }

    /**
     * 设置行为验证类型和图片数据
     */
    public void setData(BehaviorRes res, Bitmap bgBitmap) {
        if (res == null) {
            viewLoading.setVisibility(View.GONE);
            slideView.setDragEnable(true);
        } else {
            int type = stringToInt(res.verificationType);
            behaviorRes = res;
            viewLoading.setVisibility(View.GONE);
            tvTips.setText(type == TYPE_SLIDER ?
                    R.string.xn_behavior_drag : R.string.xn_behavior_click_o);
            verifyImage.setData(type, res.ypos, BitmapUtils.base64ToBitmap(res.slide), bgBitmap);
            slideView.setVisibility(type == TYPE_SLIDER ? View.VISIBLE : View.GONE);
            slideView.setDragEnable(true);
        }
    }

    public void resetWithError() {
        viewLoading.setVisibility(View.VISIBLE);
        tvResult.setText(R.string.xn_behavior_fail);
        tvResult.animate().setDuration(1000L).setListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                tvResult.setVisibility(View.VISIBLE);
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                tvResult.setVisibility(View.INVISIBLE);
            }
        }).start();
        if (TYPE_SLIDER == stringToInt(behaviorRes.verificationType)) {
            slideView.resetWithError();
        }
    }

    public boolean isShowing() {
        if (promptDialog != null) {
            return promptDialog.isShowing();
        }
        return false;
    }

    public void dismiss() {
        if (promptDialog != null && promptDialog.isShowing()) {
            promptDialog.dismiss();
        }
    }

    /**
     * 服务器返回string类型
     */
    private int stringToInt(String vType) {
        if (BehaviorReq.TYPE_SLIDE.equals(vType)) {
            return TYPE_SLIDER;
        } else if (BehaviorReq.TYPE_SINGLE_CLICK.equals(vType)) {
            return TYPE_SINGLE;
        }
        return TYPE_SINGLE;
    }
}
