package com.transsion.xuanniao.account.model;

import android.content.Context;

import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.model.data.AcquireCodeReq;
import com.transsion.xuanniao.account.model.data.BehaviorReq;
import com.transsion.xuanniao.account.model.data.VerifyCodeReq;

/**
 * @Description:
 * @author： HuNan on 2020/6/9
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public interface IVerificationModel {
    <T> void acquireCode(Context context, AcquireCodeReq params, NetCallBack<T> netCallBack);
    <T> void verifyCode(Context context, VerifyCodeReq params, NetCallBack<T> netCallBack) throws Exception;
    <T> void acquireCaptcha(Context context, NetCallBack<T> netCallBack);
    <T> void acquireCaptcha(Context context, boolean forceShow, NetCallBack<T> netCallBack);

    <T> void getBehaviorData(Context context, BehaviorReq params, NetCallBack<T> netCallBack);
    <T> void verifyBehavior(Context context, BehaviorReq params, NetCallBack<T> netCallBack);
}
