package com.transsion.xuanniao.account.model.data;

import android.content.Context;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * @Description:
 * @author： 胡南 on 2021/6/1
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CloudConfigRes implements Serializable {
    public static final String UNIT_HOUR = "hour";
    public static final String UNIT_TIMES = "times";
    public static final int TYPE_CODE_REMAIN_TIME = 8;
    public static final int TYPE_SUPPORT_LIST = 14;
    public static final int TYPE_PRIVACY_UPDATE = 15;
    public static final int TYPE_CAPTURE_OPEN = 7;
    public String versionId;
    public String versionName;
    public long timeStamp;
    public long sysTime;
    public long validPeriod;

    public ArrayList<ConfigItem> cloudClientConfigs;

    public static long getValidPeriod(Context context) {
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty(ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = gson.fromJson(ss, CloudConfigRes.class);
            return config.validPeriod;
        }
        return 60 * 1000;
    }

    public static class ConfigItem implements Serializable{
        public String configId;
        public String configName;
        public int type;
        public String typeName;
        public HashMap<String,Object> configMap;
    }

    public static class Condition implements Serializable{
        public int range;
        public String unit;
    }

    public static int getCount(Context context){
        ArrayList<ConfigItem> cloudClientConfigs = getCloudClientConfigs(context);

        if (cloudClientConfigs != null){
            for (int i = 0; i < cloudClientConfigs.size(); i++) {
                if (TYPE_CODE_REMAIN_TIME == cloudClientConfigs.get(i).type){
                    if (cloudClientConfigs.get(i).configMap != null &&
                            cloudClientConfigs.get(i).configMap.containsKey("remainTime")){
                        return Integer.parseInt(String.valueOf(cloudClientConfigs.get(i).configMap.get("remainTime")));
                    }
                    break;
                }
            }
        }

        return 100;
    }

    private static ArrayList<ConfigItem> getCloudClientConfigs(Context context){
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty(ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = gson.fromJson(ss, CloudConfigRes.class);
            return config.cloudClientConfigs;
        }
        return null;
    }
    public static boolean privacyNeedAgree(Context context){
        ClientPrefs prefs = ClientPrefs.get(context);
        ConfigItem configItem = getConfig(context, TYPE_PRIVACY_UPDATE);
        if (configItem != null && configItem.configMap != null){
            String privacyVersion = String.valueOf(configItem.configMap.get("privacyVersion"));
            String userAgreementVersion = String.valueOf(configItem.configMap.get("userAgreementVersion"));
            boolean privacyUpdate = conversionVersion(privacyVersion) > conversionVersion(prefs.getPrivacyVersion());
            boolean userAgreementUpdate = conversionVersion(userAgreementVersion) > conversionVersion(prefs.getUserAgreementVersion());
            return privacyUpdate || userAgreementUpdate;
        }
        return false;
    }

    private static ConfigItem getConfig(Context context,int type){
        ArrayList<ConfigItem> cloudClientConfigs = getCloudClientConfigs(context);
        if (cloudClientConfigs != null){
            for (int i = 0; i < cloudClientConfigs.size(); i++) {
                if (type == cloudClientConfigs.get(i).type){
                    return cloudClientConfigs.get(i);
                }
            }
        }
        return null;
    }
    public static void privacyAgree(Context context){
        ClientPrefs prefs = ClientPrefs.get(context);
        ConfigItem configItem = getConfig(context, TYPE_PRIVACY_UPDATE);
        if (configItem != null && configItem.configMap != null){
            String privacyVersion = String.valueOf(configItem.configMap.get("privacyVersion"));
            String userAgreementVersion = String.valueOf(configItem.configMap.get("userAgreementVersion"));
            prefs.setPrivacyVersion(privacyVersion);
            prefs.setUserAgreementVersion(userAgreementVersion);
            prefs.save();
        }
    }

    public static String privacyVersion(Context context){
        ClientPrefs prefs = ClientPrefs.get(context);
        ConfigItem configItem = getConfig(context, TYPE_PRIVACY_UPDATE);
        if (configItem != null && configItem.configMap != null){
            return String.valueOf(configItem.configMap.get("privacyVersion"));
        }
        return "";
    }

    private static int conversionVersion(String version){
        if (!TextUtils.isEmpty(version)){
            try {
                return Integer.parseInt(version);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static boolean needRefresh(Context context){
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty(ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = gson.fromJson(ss, CloudConfigRes.class);
            return System.currentTimeMillis() - config.timeStamp >= 24*60*60*1000;
        }
        return true;
    }

    public static String getVersion(Context context){
        String ss = ClientPrefs.get(context).getCloudConfig();
        if (!TextUtils.isEmpty(ss)) {
            Gson gson = new Gson();
            CloudConfigRes config = gson.fromJson(ss, CloudConfigRes.class);
            return config.versionId;
        }
        return "";
    }

    public static boolean captureOpen(Context context){
        ConfigItem configItem = getConfig(context,TYPE_CAPTURE_OPEN);
        if (configItem != null && configItem.configMap != null){
            if (configItem.configMap.containsKey("capture-open")){
                return "true".equals(configItem.configMap.get("capture-open"));
            }
        }
        return false;
    }

    public static String support(Context context){
        ConfigItem configItem = getConfig(context,TYPE_SUPPORT_LIST);
        if (configItem != null && configItem.configMap != null){
            if (configItem.configMap.containsKey("support")){
                return String.valueOf(configItem.configMap.get("support")).replace(", Carlcare Account", "");
            }
        }
        return "Hi Account,X Account";
    }
}