package com.transsion.xuanniao.account.model.data;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.RSAEncryptUtil;
import com.transsion.xuanniao.account.comm.utils.Sha256Utils;

import java.io.Serializable;

/**
 * @Description:
 * @author： 胡南 on 2021/5/23
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class EncryptRes implements Serializable {
    public String responseData;
    public String responseSign;
    public boolean checkSign(){
        if (TextUtils.isEmpty(responseData) || TextUtils.isEmpty(responseSign)){
            return false;
        }

        try {
            byte[] sha256 = Sha256Utils.getSHA256(RSAEncryptUtil.base64Decode(responseData));
            return RSAEncryptUtil.checkSignature(sha256, responseSign, Key.PUBLIC_KEY);
        }catch (Exception e){
            e.printStackTrace();
        }
        return false;
    }

    public String dataJson(CipherHelper cipherHelper){
        try {
            if (cipherHelper != null){
               byte[] data =  cipherHelper.decrypt(RSAEncryptUtil.base64Decode(responseData));
               return new String(data);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return "";
    }

    public boolean isSafe(String json,String verifyId){
//        LogUtils.d("verifyId:"+verifyId);
        if (!TextUtils.isEmpty(json)){
            Gson gson = new Gson();
            BaseEncryptRes base = gson.fromJson(json, BaseEncryptRes.class);
//            LogUtils.d("base verifyId:"+base.verifyId);
            if (!TextUtils.isEmpty(base.verifyId)){
                return TextUtils.equals(base.verifyId, verifyId);
            }
        }

        return true;
    }
}