package com.transsion.xuanniao.account.model.impl;

import android.content.Context;

import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.net.NetWorkProxy;
import com.transsion.xuanniao.account.comm.net.UrlFactory;
import com.transsion.xuanniao.account.comm.tee.CipherHelper;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.model.IVerificationModel;
import com.transsion.xuanniao.account.model.data.AcquireCodeReq;
import com.transsion.xuanniao.account.model.data.BehaviorReq;
import com.transsion.xuanniao.account.model.data.CommReq;
import com.transsion.xuanniao.account.model.data.VerifyCodeReq;

import java.util.HashMap;

/**
 * @Description:
 * @author： 胡南 on 2021/4/20
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class VerificationModel implements IVerificationModel {
    private String sceneCode;
    public VerificationModel(String sceneCode){
        this.sceneCode = sceneCode;
    }
    @Override
    public <T> void acquireCode(Context context, AcquireCodeReq params, NetCallBack<T> netCallBack) {
        params.setSceneCode(sceneCode);
        params.setClientId(XNApiManager.instance().getClientId());
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost(UrlFactory.ACQUIRE_CODE,params,netCallBack);
    }

    @Override
    public <T> void verifyCode(Context context, VerifyCodeReq params, NetCallBack<T> netCallBack) throws Exception {
        params.setSceneCode(sceneCode);
        params.setClientId(XNApiManager.instance().getClientId());
        params.setVerifyId(String.valueOf(System.currentTimeMillis()));
        CipherHelper cipherHelper = TeeManager.instance().generateCipher();
        cipherHelper.setVerifyId(params.getVerifyId());
        netCallBack.setCipherHelper(cipherHelper);
        Object req = CommReq.generateReq(context, cipherHelper, params);
        NetWorkProxy proxy = new NetWorkProxy(context);
        if (TeeManager.instance().isTeeEnable()) {
            proxy.requestPost(UrlFactory.VERIFY_CODE_CRYPT, req, netCallBack);
        } else {
            proxy.requestPost(UrlFactory.VERIFY_CODE, req, netCallBack);
        }
    }

    @Override
    public <T> void acquireCaptcha(Context context, NetCallBack<T> netCallBack) {
        HashMap<String,String> params = new HashMap<>();
        params.put("sceneCode", sceneCode);
        params.put("clientId", XNApiManager.instance().getClientId());
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost(UrlFactory.ACQUIRE_CAPTCHA,params,netCallBack);
    }

    @Override
    public <T> void acquireCaptcha(Context context, boolean forceShow, NetCallBack<T> netCallBack) {
        HashMap<String,Object> params = new HashMap<>();
        params.put("sceneCode", sceneCode);
        params.put("clientId", XNApiManager.instance().getClientId());
        params.put("forceShow", forceShow);
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost(UrlFactory.ACQUIRE_CAPTCHA,params,netCallBack);
    }

    @Override
    public <T> void getBehaviorData(Context context, BehaviorReq params, NetCallBack<T> netCallBack) {
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost(UrlFactory.BEHAVIOR_DATA,params,netCallBack);
    }

    @Override
    public <T> void verifyBehavior(Context context, BehaviorReq params, NetCallBack<T> netCallBack) {
        NetWorkProxy proxy = new NetWorkProxy(context);
        proxy.requestPost(UrlFactory.VERIFY_BEHAVIOR,params,netCallBack);
    }
}
