/**
 * CopyRight (c) 2016-2021 Transsion .Co.Ltd.
 */

package com.transsion.xuanniao.account.tools;

import java.util.Collection;
import java.util.List;

/**
 * <数组工具类>
 *
 * @author ming.wang
 * @version [V8.0, 2021/6/17]
 * @since V8.0
 */
public final class ArrayUtils {
    private static final String TAG = "ArrayUtils";

    private ArrayUtils() {
    }

    /**
     * 获取列表条数
     *
     * @param list 列表数据
     * @return 条数
     */
    public static int getListSize(List list) {
        return isEmpty((Collection) list) ? 0 : list.size();
    }

    /**
     * 判断数据是否为空
     *
     * @param collection 数据接口
     * @return true 空 false 非空
     */
    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.isEmpty();
    }
}
