package com.transsion.xuanniao.account.comm.mvpbase;

/**
 * @Description:
 * @author： HuNan on 2020/5/19
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class BasePresenter<T extends IView> implements IPresenter<T> {
    private T iView;
    @Override
    public void attachView(T iView) {
        this.iView = iView;
    }

    @Override
    public void detachView() {
        iView = null;
    }

    public T getIView() {
        return iView;
    }

    public boolean isViewAttached(){
        return iView != null;
    }

    public void checkViewAttached() {
        if (!isViewAttached()) throw new MvpViewNotAttachedException();
    }

    public static class MvpViewNotAttachedException extends RuntimeException {
        private static final long serialVersionUID = -2135659522815788547L;

        public MvpViewNotAttachedException() {
            super("Please call Presenter.attachView(MvpView) before" +
                    " requesting data to the Presenter");
        }
    }
}
