package com.transsion.xuanniao.account.comm.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.View;

import androidx.core.content.FileProvider;

import java.io.File;

import tech.palm.lib.utils.CommonUtils;

import static java.lang.System.getProperty;

import com.transsion.xuanniao.account.comm.tee.TeeManager;


/**
 * @Description:
 * @author： HuNan on 2020/7/8
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class OSUtils {

    public static boolean isOldPalmID = false;  // 当前系统是否是PalmID账号

    public static Intent getAppDetailSettingIntent(Context context) {
        Intent localIntent = new Intent();
        localIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts("package", context.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction(Intent.ACTION_VIEW);
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
        }
        return localIntent;
    }

    public static String getMcc(Context context){
        try {
            TelephonyManager tm = (TelephonyManager) context.getApplicationContext().getSystemService(Context.TELEPHONY_SERVICE);
            if (null == tm) return "";
            String result = tm.getSimOperator();
            if (result != null && result.length() >= 3){
                return result.substring(0, 3);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getBrand(){
        String osType = CommonUtils.SystemPropertiesGet("ro.tranos.type");
        String brand = Build.BRAND;
        if (TextUtils.isEmpty(osType)) {
            if ("Infinix".equalsIgnoreCase(brand)) {
                return "Infinix";
            } else if ("itel".equalsIgnoreCase(brand)) {
                return "itel";
            } else if ("TECNO".equalsIgnoreCase(brand)){
                return "TECNO";
            } else if ("VIMOQ".equalsIgnoreCase(brand)) {
                return "VIMOQ";
            }
        } else {
            if ("xos".equalsIgnoreCase(osType) && "Infinix".equalsIgnoreCase(brand)) {
                return "Infinix";
            } else if ("itel".equalsIgnoreCase(osType)) {
                if ("VIMOQ".equalsIgnoreCase(brand)) {
                    return "VIMOQ";
                } else if ("itel".equalsIgnoreCase(brand)) {
                    return "itel";
                }
            } else if ("hios".equalsIgnoreCase(osType) && "TECNO".equalsIgnoreCase(brand)) {
                return "TECNO";
            }
        }
        return "";
    }

    /**
     * 在业务方应用内登录
     */
    public static String getBrandId() {
        String osType = CommonUtils.SystemPropertiesGet("ro.tranos.type");
        String brand = Build.BRAND;
        if (TextUtils.isEmpty(osType)) {
            if ("Infinix".equalsIgnoreCase(brand)) {
                return "Infinix ID";
            } else if ("itel".equalsIgnoreCase(brand)) {
                return "itel ID";
            } if ("VIMOQ".equalsIgnoreCase(brand)) {
                return "VIMOQ ID";
            } else if ("TECNO".equalsIgnoreCase(brand)) {
                return "TECNO ID";
            }
        } else {
            if ("xos".equalsIgnoreCase(osType) && "Infinix".equalsIgnoreCase(brand)) {
                return "Infinix ID";
            } else if ("itel".equalsIgnoreCase(osType)) {
                if ("VIMOQ".equalsIgnoreCase(brand)) {
                    return "VIMOQ ID";
                } else if ("itel".equalsIgnoreCase(brand)) {
                    return "itel ID";
                }
            } else if (("hios".equalsIgnoreCase(osType)) && "TECNO".equalsIgnoreCase(brand)) {
                return "TECNO ID";
            }
        }
        return "TECNO ID";
    }

    /**
     * 获取应用图标
     *
     * @param context
     * @param packageName
     * @return
     */
    public static synchronized Drawable getAppDrawable(Context context, String packageName) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        Drawable drawable = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(packageName, 0);
        } catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        if (applicationInfo != null) {
            drawable = packageManager.getApplicationIcon(applicationInfo);
        }
        return drawable;
    }

    public static boolean sDCardAvailable(Context context){
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) != null;
    }

    public static boolean isRtl(Context context) {
        return (context.getResources().getConfiguration().getLayoutDirection() == View.LAYOUT_DIRECTION_RTL);
    }

    public static Uri getFromFileProvider(Context context,String authority, File file){
        try {
            return FileProvider.getUriForFile(context, authority, file);
        }catch (IllegalArgumentException e){
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 转换为品牌h5地址
     */
    public static String toBrandUrl(String url) {
        String brandId = toBrandId();
        if (!TextUtils.isEmpty(brandId)) {
            return url.replace("legal-agreement", brandId + "/legal-agreement");
        }
        return url;
    }

    /**
     * 请求faq等协议
     */
    public static String toBrandId() {
        if (isOldPalmID) {
            return "";  // PalmID协议
        } else {
            String brandId = "infinix-id";
            String linkedBrandId = TeeManager.instance().getLinkedBrandId();
            LogUtils.d("lbd = " + linkedBrandId);
            if (!TextUtils.isEmpty(linkedBrandId)) {
                if ("itel ID".equalsIgnoreCase(linkedBrandId)) {
                    brandId = "itel-id";
                } else if ("TECNO ID".equalsIgnoreCase(linkedBrandId)) {
                    brandId = "tecno-id";
                } else if ("VIMOQ ID".equalsIgnoreCase(linkedBrandId)) {
                    brandId = "vimoq-id";
                }
            } else {
                String brand = getBrand();  // 在传音手机上显示对应品牌ID，非传音手机上显示TECNO ID
                if (!TextUtils.isEmpty(brand)) {
                    if ("itel".equalsIgnoreCase(brand)) {
                        brandId = "itel-id";
                    } else if ("TECNO".equalsIgnoreCase(brand)) {
                        brandId = "tecno-id";
                    } else if ("VIMOQ".equalsIgnoreCase(brand)) {
                        brandId = "vimoq-id";
                    }
                }
            }
            return brandId;
        }
    }

    /**
     * 使用品牌id替换PalmID字串
     */
    public static String toBrandId(String src) {
        if (isOldPalmID) {
            return src.replace("TECNO", "Palm");  // 保留PalmID字串
        } else {
            String linkedBrandId = TeeManager.instance().getLinkedBrandId();
            LogUtils.d("lbd = " + linkedBrandId);
            if (!TextUtils.isEmpty(linkedBrandId)) {  // 发生过关联登录
                return src.replace("TECNO", linkedBrandId.split(" ")[0]);
            } else {
                String brand = getBrand();  // 在传音手机上显示对应品牌ID，非传音手机上显示Infinix ID
                return TextUtils.isEmpty(brand) ? src.replace("TECNO", "Infinix") : src.replace("TECNO", brand);
            }
        }
    }

    /**
     * 使用品牌id替换PalmID字串
     */
    public static String toBrandId(String src, String brand) {
        if (TextUtils.isEmpty(brand)) {
            return toBrandId(src);
        }
        return src.replace("TECNO", brand);
    }

    /**
     * 手机使用PalmID账号
     */
    public static boolean isOldPalmID(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager()
                    .getApplicationInfo("tech.palm.id",
                            PackageManager.GET_META_DATA);
            String metaData = appInfo.metaData.getString("com.palm.id.clientId");
            isOldPalmID = metaData == null || metaData.length() == 0;
            return isOldPalmID;
        } catch (Exception e) {
//            e.printStackTrace();
        }
        isOldPalmID = false;
        return false;
    }
}
