package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.BidiFormatter;
import android.text.Editable;
import android.text.InputFilter;
import android.text.InputType;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

import com.transsion.core.utils.ScreenUtil;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.constant.GlobalConstant;
import com.transsion.xuanniao.account.comm.constant.MaxNum;

import tech.palm.lib.athena.AthenaImpl;

/**
 * @Description:
 * @author： 胡南 on 2021/4/16
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class AccountInput extends FrameLayout {
    private EditText edit;
    private RelativeLayout accountLeftL;
    private TextView cc;
    private IAccountInputListener inputListener;
    private boolean isSupportUserName;
    private ImageView logo;
    private PopupWindow emailAssociation;
    private boolean isSelectAssociation;
    private EditFocus editFocus;
//    private RelativeLayout contentL;
    private BidiFormatter bidiFormatter;
    private boolean canShowPopView = false;

    public AccountInput(@NonNull Context context) {
        super(context);
    }

    public AccountInput(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.xn_account_input, this, true);
        initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        initView();
        bidiFormatter = BidiFormatter.getInstance();
    }

    private void initAttr(TypedArray array) {
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = findViewById(R.id.line);
        lineView.setVisibility(showLine ? View.VISIBLE : INVISIBLE);
        if (hint != null && !hint.isEmpty()) {
            EditText phoneEdit = findViewById(R.id.edit);
            phoneEdit.setHint(hint);
        }
        array.recycle();
    }

    private void initView() {
        edit = findViewById(R.id.edit);
        accountLeftL = findViewById(R.id.accountLeftL);
//        contentL = findViewById(R.id.contentL);
        cc = findViewById(R.id.cc);
//        cc.setPaintFlags(cc.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
        logo = findViewById(R.id.logo);
        cc.setOnClickListener(new Click());
        edit.setOnFocusChangeListener(new FocusListener());
        edit.addTextChangedListener(watch);
//        changeLayoutDirection();
    }

//    private void changeLayoutDirection(){
//        if (isPhone(getText())){
//            contentL.setLayoutDirection(LAYOUT_DIRECTION_LTR);
//        }else {
//            contentL.setLayoutDirection(LAYOUT_DIRECTION_INHERIT);
//        }
//    }

    public void setHint(String hint) {
        edit.setHint(hint);
    }

    public String getText() {
        return edit.getText().toString();
    }

    public void setCc(String text) {
        cc.setText(bidiFormatter.unicodeWrap(text, TextDirectionHeuristics.LTR));
        if (TextUtils.isEmpty(text)||TextUtils.isEmpty(text.trim())) {
            return;
        }
        if (text.trim().length() >= 5){
            cc.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
        }else {
            cc.setTextSize(TypedValue.COMPLEX_UNIT_SP, 14);
        }
    }

    public String getCc() {
        return cc.getText().toString();
    }

    public void setText(String text) {
        if (isEmail(text)){
            edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MaxNum.EMAIL)});
        }else if (isPhone(text)){
            edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MaxNum.PHONE)});
        }else {
            edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MaxNum.ACCOUNT_ID)});
        }
        edit.setText(text);
        Editable b = edit.getText();
        edit.setSelection(b.length());
    }

    public void addWatch(TextWatcher watcher) {
        edit.addTextChangedListener(watcher);
    }

    public void setInputListener(IAccountInputListener inputListener) {
        this.inputListener = inputListener;
    }

    public boolean isSupportUserName() {
        return isSupportUserName;
    }

    public void setSupportUserName(boolean supportUserName) {
        isSupportUserName = supportUserName;
        identifyAccountType(2);
    }

    public int getType() {
        if (isPhone(getText())) {
            return GlobalConstant.ACCOUNT_PHONE;
        } else if (isEmail(getText())) {
            return GlobalConstant.ACCOUNT_EMAIL;
        } else {
            return GlobalConstant.ACCOUNT_USERNAME;
        }
    }

    public void showEmailAssociation() {

    }

    public void hideEmailAssociation() {

    }

    public boolean isShowEmailAssociation(){
        if (emailAssociation != null){
            return emailAssociation.isShowing();
        }
        return false;
    }

    public EditText getEdit() {
        return edit;
    }

    class Click extends CustomClickListener {
        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.cc) {
                if (inputListener != null) {
                    inputListener.onSelectCc();
                }
            }
        }
    }

    class FocusListener implements OnFocusChangeListener {
        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            View line = findViewById(R.id.line);
            int colorId = hasFocus ? R.color.os_fill_primary_color : R.color.os_gray_secondary_color;
            line.setBackgroundColor(getResources().getColor(colorId));
            line = findViewById(R.id.line1);
            line.setBackgroundColor(getResources().getColor(colorId));
            if (!hasFocus) {
                if (isSupportUserName) {

                } else {
                    if (!TextUtils.isEmpty(getText())) {
                        String type = isPhone(getText()) ? "Phone" : "Mail";
                        AthenaImpl.getInstance(getContext()).accountFillCl(type, getText().length());
                    }
                }
                hideEmailAssociation();
            }
            setLogoColor(hasFocus);
            if (editFocus != null){
                editFocus.onFocusChange(v, hasFocus);
            }
        }
    }

    public boolean isCanShowPopView() {
        return canShowPopView;
    }

    public void setCanShowPopView(boolean canShowPopView) {
        this.canShowPopView = canShowPopView;
    }

    /**
     * 限定输入号码
     */
    public void setOnlyPhoneNum() {
        edit.setHint(R.string.xn_phone_num);
        edit.setInputType(InputType.TYPE_CLASS_PHONE);
        edit.setKeyListener(DigitsKeyListener.getInstance("0123456789"));
        edit.removeTextChangedListener(watch);
        logo.setVisibility(GONE);
        accountLeftL.setVisibility(VISIBLE);
    }

    public void setLogoColor(boolean hasFocus) {
        AppCompatImageView logo = findViewById(R.id.logo);
        Drawable drawable = logo.getDrawable();
        drawable.setTint(getResources().getColor(hasFocus ? R.color.xn_input_logo_color_s : R.color.xn_input_logo_color, null));
        cc.setTextAppearance(hasFocus ? R.style.font_black_14 : R.style.font_black_14_t40);
    }
    private int beforeCount;
    private final Watch watch = new Watch();
    class Watch implements TextWatcher {
        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            beforeCount = getText().length();
        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        @Override
        public void afterTextChanged(Editable s) {
            identifyAccountType(s.length() - beforeCount);
        }
    }

    private void identifyAccountType(int changeCount) {
        if (isPhone(getText())) {
            logo.setVisibility(GONE);
            accountLeftL.setVisibility(VISIBLE);
            if (emailAssociation != null && emailAssociation.isShowing()) {
                emailAssociation.dismiss();
            }
            edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MaxNum.PHONE)});
        } else if (isEmail(getText())) {
            logo.setVisibility(VISIBLE);
            accountLeftL.setVisibility(GONE);
            logo.setImageResource(R.drawable.xn_icon_email);
            if (changeCount <= 1) {
                showEmailAssociation();
            }
            edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MaxNum.EMAIL)});
            setLogoColor(true);
        } else {
            logo.setVisibility(VISIBLE);
            accountLeftL.setVisibility(GONE);
            logo.setImageResource(R.drawable.xn_icon_account);
            if (emailAssociation != null && emailAssociation.isShowing()) {
                emailAssociation.dismiss();
            }
            edit.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MaxNum.ACCOUNT_ID)});
            setLogoColor(true);
        }
//        changeLayoutDirection();
    }

    public boolean isPhone(String value) {
        if (TextUtils.isEmpty(value) || value.length() < 3) {
            return false;
        }

        String rule = "[0-9]+";
        return value.matches(rule);
    }

    private boolean isEmail(String value) {
        if (TextUtils.isEmpty(value)) {
            return false;
        }
        if (isSupportUserName) {
            return value.contains("@");
        } else {
            return !isNum(value);
        }
    }

    private boolean isNum(String value) {
        if (TextUtils.isEmpty(value)) {
            return false;
        }
        String rule = "[0-9]+";
        return value.matches(rule);
    }

    private boolean isAccount(String value) {
        if (!isSupportUserName || TextUtils.isEmpty(value) || value.length() < 3) {
            return false;
        }

        return !isPhone(value) && !isEmail(value);
    }

    public void setEditFocus(EditFocus editFocus) {
        this.editFocus = editFocus;
    }

    public interface IAccountInputListener {
        void onSelectCc();
    }

    public interface EditFocus{
        void onFocusChange(View v, boolean hasFocus);
    }
}
