package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.transsion.core.utils.ScreenUtil;
import com.transsion.xuanniao.account.R;

/**
 * @Description:
 * @author： HuNan on 2020/6/18
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class BehaviorVerifyInput extends FrameLayout {

    public static final int STATE_NORMAL = 0;
    public static final int STATE_SUCCESS = 1;
    public static final int STATE_FAILED = 2;
    private int state = STATE_NORMAL;
    private RelativeLayout contentL;
    private ImageView ivBehaviorLogo, ivRefresh;
    private TextView tvBehavior;
    private boolean hasRadiusBg = false;
    private VerifyListener verifyListener;

    public interface VerifyListener {
        void showVerifyDialog();
    }

    public BehaviorVerifyInput(Context context) {
        super(context);
    }

    public BehaviorVerifyInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.xn_view_behavior_input, this, true);
        initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        initView();
    }

    private void initAttr(TypedArray array){
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = findViewById(R.id.line);
        lineView.setVisibility(showLine ? View.VISIBLE : INVISIBLE);
        array.recycle();
    }

    public void setVerifyListener(VerifyListener listener) {
        verifyListener = listener;
    }

    public void setState(int newState) {
        state = newState;
        View lineView = findViewById(R.id.line);
        switch (newState) {
            case STATE_NORMAL:
                if (hasRadiusBg) {
                    contentL.setBackgroundResource(R.drawable.xn_brand_radius_grey_bg);
                } else {
                    lineView.setBackgroundColor(getResources().getColor(R.color.os_gray_secondary_color));
                }
//                ivBehaviorLogo.setImageResource(R.drawable.xn_verify_logo);
                ivRefresh.setVisibility(INVISIBLE);
                tvBehavior.setText(R.string.xn_behavior_click);
                tvBehavior.setTextColor(ContextCompat.getColor(getContext(), R.color.xn_behavior_verify_normal));
                break;
            case STATE_SUCCESS:
                if (hasRadiusBg) {
                    contentL.setBackgroundResource(R.drawable.xn_brand_radius_green_bg);
                } else {
                    lineView.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.os_gray_secondary_color));
                }
//                ivBehaviorLogo.setImageResource(R.drawable.xn_verify_logo_success);
                ivRefresh.setVisibility(INVISIBLE);
                tvBehavior.setText(R.string.xn_behavior_success);
                tvBehavior.setTextColor(ContextCompat.getColor(getContext(), R.color.xn_behavior_verify_success));
                break;
            case STATE_FAILED:
                if (hasRadiusBg) {
                    contentL.setBackgroundResource(R.drawable.xn_brand_radius_red_bg);
                } else {
                    lineView.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.os_red_basic_color));
                }
//                ivBehaviorLogo.setImageResource(R.drawable.xn_verify_logo_fail);
                ivRefresh.setVisibility(VISIBLE);
                tvBehavior.setText(R.string.xn_behavior_fail);
                tvBehavior.setTextColor(ContextCompat.getColor(getContext(), R.color.xn_behavior_verify_fail));
                break;
        }
    }

    public int getState() {
        return state;
    }

    private void initView() {
        contentL = findViewById(R.id.contentL);
        tvBehavior = findViewById(R.id.tvBehavior);
        tvBehavior.setOnClickListener(new Click());
        ivRefresh = findViewById(R.id.ivRefresh);
        ivRefresh.setOnClickListener(new Click());
        setState(state);
    }

    class Click extends CustomClickListener{
        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.tvBehavior){
                if (state == STATE_NORMAL) {
                    if (verifyListener != null) {
                        verifyListener.showVerifyDialog();
                    }
                }
            } else if (v.getId() == R.id.ivRefresh) {
                if (verifyListener != null) {
                    verifyListener.showVerifyDialog();
                }
            }
        }
    }

    /**
     * 页面销毁缓存状态(切换深色模式)
     */
    public void saveState(Bundle outState) {
        outState.putInt("bv_state", state);
        outState.putInt("bv_visibility", getVisibility());
    }

    /**
     * 页面恢复之前状态(切换深色模式)
     */
    public void restoreState(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey("bv_state")) {
                setState(inState.getInt("bv_state"));
            }
            if (inState.containsKey("bv_visibility")) {
                setVisibility(inState.getInt("bv_visibility"));
            }
        }
    }
}
