package com.transsion.xuanniao.account.login.presenter;

import com.transsion.xuanniao.account.comm.mvpbase.BasePresenter;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.login.view.CountrySelectActivity;
import com.transsion.xuanniao.account.model.ICountryModel;
import com.transsion.xuanniao.account.model.data.CountryData;
import com.transsion.xuanniao.account.model.impl.CountryModel;

import java.util.ArrayList;

/**
 * @Description:
 * @author： 胡南 on 2022/1/14
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CountryPresenter extends BasePresenter<ICountryView> {
    private CountryData countryData;
    private ICountryModel countryModel;

    public CountryPresenter(){
        countryModel = new CountryModel();
    }

    public void getCountriesFromCache(){
        countryModel.getCountriesFromCash(activity(), new NetCallBack<CountryData>(activity(),CountryData.class) {
            @Override
            public void onSuccess(int code, CountryData result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                countryData = result;
                if (countryData == null){
                    getCountriesFromNet();
                }else {
                    getIView().fillDataToPage(countryData.countries);
                    long now = System.currentTimeMillis();
                    if (Math.abs(now - countryData.baseTime) > countryData.validity){
                        getCountriesFromNet();
                    }
                }
            }

            @Override
            public void onRetry() {

            }
        });
    }

    public void getCountriesFromNet(){
        countryModel.getCountriesFromNet(activity(),
                new NetCallBack<CountryData>(activity(),CountryData.class) {
            @Override
            public void onSuccess(int code, CountryData result, String tag) {
                if (!isViewAttached()){
                    return;
                }
                if (result != null && result.countries != null && result.countries.size() > 0){
                    countryData = result;
                    countryData.baseTime = System.currentTimeMillis();
                    countryModel.saveCountryToCash(activity(), countryData);
                    getIView().fillDataToPage(countryData.countries);
                }
            }

            @Override
            public void onRetry() {

            }
        });
    }
    public ArrayList<CountryData.Country> getCountries(){
        if (countryData == null){
            return null;
        }
        return countryData.countries;
    }

    private CountrySelectActivity activity(){
        return (CountrySelectActivity) getIView().getContext();
    }
}