package com.transsion.xuanniao.account.model.data;

import android.content.Context;
import android.text.TextUtils;

import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.utils.OSUtils;
import com.transsion.xuanniao.account.comm.utils.SystemPropertiesProxy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

/**
 * @Description:
 * @author： HuNan on 2020/6/9
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CountryData implements Serializable {
    public ArrayList<Country> countries;
    public long validity;
    public long baseTime;
    public static class Country implements Serializable {
        public String country;//
        public String code;
        public String mcc;
        public int resId;
        public boolean isSelected;
        public String localName;
        public String iso;
        public String language;
        public String displayName;

        public Country(String iso,String localName, String country, String code, String mcc, int resId, boolean isSelected){
            this.iso = iso;
            this.country = country;
            this.code = code;
            this.mcc = mcc;
            this.resId = resId;
            this.isSelected = isSelected;
            this.localName = localName;
        }
        public Country(String iso,String localName, String country, String code, String mcc, int resId){
            this(iso,localName, country,code,mcc,resId,false);
        }

    }

    public static String getCountryCode(Context context,ArrayList<Country> countryData){
        ClientPrefs prefs = ClientPrefs.get(context);
        String code = prefs.getCountryCode();
        if (code.isEmpty() && countryData != null){
            String mcc = OSUtils.getMcc(context);
            if (!TextUtils.isEmpty(mcc)) {
                for (Country item : countryData) {
                    if (item.mcc.equals(mcc)) {
                        code = item.code;
                    }
                }
            } else {
                String country
                        = SystemPropertiesProxy.get(context, "persist.sys.oobe_country");
                if (!TextUtils.isEmpty(country)) {
                    for (Country item : countryData) {
                        if (country.equalsIgnoreCase(item.iso)) {
                            code = item.code;
                        }
                    }
                }
            }
        }

        if (TextUtils.isEmpty(code)){
            Locale l = Locale.getDefault();
            String countryName = l.getDisplayCountry(Locale.US);
            if(countryName.contains("(")){
                String[] countryNames = countryName.split("\\(");
                countryName = countryNames[0].trim();
            }
            if ("russia".equalsIgnoreCase(countryName)){
                countryName = "Russian Federation";
            } else if ("United States".equalsIgnoreCase(countryName)) {
                countryName = "United States of America";
            }
            code = getCode(countryName,countryData);
        }
        return code;
    }

    public static String getCode(String name,ArrayList<Country> countries){
        if ("Taiwan".equals(name)){
            name = "Taiwan/China";
        }
        if (countries != null){
            for (int i = 0; i < countries.size(); i++) {
                if (TextUtils.equals(countries.get(i).country,name) ||
                        TextUtils.equals(countries.get(i).localName,name)){
                    return countries.get(i).code;
                }
            }
        }
        return "";
    }

    public static CountryData makeCountryData(Context context){
        CountryData countryData = new CountryData();
        countryData.validity = 0;
        countryData.baseTime = 0;
        countryData.countries = new ArrayList<>();

        for (Country country :
                CacheCountries.countriesData) {
            Country item = new Country(country.iso,country.localName, country.country, country.code, country.mcc, 0);
            if (country.resId == R.string.HK || country.resId == R.string.TW || country.resId == R.string.MO){
                item.displayName = context.getString(R.string.xn_china) + "/" + context.getString(country.resId);
            }else {
                item.displayName = context.getResources().getString(country.resId);
            }

            countryData.countries.add(item);
        }

        return countryData;
    }

//    public static ArrayList<Country> getCountries(){
//        return countriesData;
//    }



    public static String getCountryName(Context context,String enName,ArrayList<Country> countries){
        for (int i = 0; i < countries.size(); i++) {
            if (TextUtils.equals(enName, countries.get(i).country)){
                int id = countries.get(i).resId;
                if (id == R.string.HK || id == R.string.TW || id == R.string.MO){
                    return context.getString(R.string.xn_china) + "/" + context.getString(id);
                }
                return context.getString(id);
            }
        }
        return enName;
    }

    public static String getCode(Context context,String name,ArrayList<Country> countries){
        String enName = getEnName(context, name,countries);
        return getCode(enName,countries);
    }

    public static String getEnName(Context context,String name,ArrayList<Country> countries){
        if (!TextUtils.isEmpty(name) && countries != null){
            for (int i = 0; i < countries.size(); i++) {
                String matchName = null;
                int id = countries.get(i).resId;
                if (id == R.string.HK || id == R.string.TW || id == R.string.MO){
                    matchName = context.getString(R.string.xn_china) + "/" + context.getString(id);
                }else {
                    if (id  > 0){
                        matchName = context.getString(id);
                    }else {
                        matchName = countries.get(i).displayName;
                    }
                }
                if (TextUtils.equals(name,matchName)){
                    return countries.get(i).country;
                }
            }
        }

        return "";
    }

}
