/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.mvpbase;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.os.ConfigurationCompat;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;
import com.transsion.widgetslib.dialog.OSLoadingBottomDialog;
import com.transsion.widgetslib.util.Utils;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import java.lang.ref.WeakReference;
import java.util.IllegalFormatConversionException;
import java.util.Locale;
import java.util.UnknownFormatConversionException;

public class BaseActivity
extends Activity {
    private Dialog mDialog;
    private float x;
    private float y;

    public void onCreate(Bundle savedInstanceState) {
        this.setAppTheme();
        super.onCreate(savedInstanceState);
        CoreUtil.init((Context)this);
        Locale defLocale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        Window window = this.getWindow();
        LogUtils.d("defLocale = " + defLocale + ", window = " + window);
        if (defLocale != null && window != null) {
            int layoutDirection = TextUtils.getLayoutDirectionFromLocale((Locale)defLocale);
            LogUtils.d("layoutDirection = " + layoutDirection);
            window.getDecorView().setLayoutDirection(layoutDirection);
        }
    }

    public void attachBaseContext(Context newBase) {
        Locale sysLocale = ConfigurationCompat.getLocales((Configuration)Resources.getSystem().getConfiguration()).get(0);
        Locale defLocale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        LogUtils.d("sysLocale = " + sysLocale + ", defLocale = " + defLocale);
        if (sysLocale == defLocale || defLocale == null) {
            super.attachBaseContext(newBase);
            return;
        }
        try {
            Locale.setDefault(defLocale);
            Resources resources = newBase.getResources();
            final Configuration configuration = resources.getConfiguration();
            if (Build.VERSION.SDK_INT >= 24) {
                configuration.setLocales(new LocaleList(new Locale[]{defLocale}));
            } else {
                configuration.locale = defLocale;
                resources.updateConfiguration(configuration, resources.getDisplayMetrics());
            }
            Context context = Build.VERSION.SDK_INT >= 25 ? newBase.createConfigurationContext(configuration) : newBase;
            ContextThemeWrapper wrappedContext = new ContextThemeWrapper(context, R.style.Theme_AppCompat_Empty){

                public void applyOverrideConfiguration(Configuration newConfiguration) {
                    newConfiguration.setTo(configuration);
                    super.applyOverrideConfiguration(newConfiguration);
                }
            };
            super.attachBaseContext((Context)wrappedContext);
        }
        catch (Exception e) {
            super.attachBaseContext(newBase);
        }
    }

    public void setAppTheme() {
        try {
            if (this.getResources().getBoolean(R.bool.sdk_theme_is_dynamic)) {
                Utils.setAppTheme((Context)this, (int)R.style.XNAppTheme, (int)R.style.XNAppTheme_xos, (int)R.style.XNAppTheme);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                int vis = this.getWindow().getDecorView().getSystemUiVisibility();
                this.getWindow().getDecorView().setSystemUiVisibility(vis &= 0xFFFFFFEF);
            }
        }
        catch (Exception e) {
            LogUtils.d(Log.getStackTraceString((Throwable)e));
        }
    }

    public int getStatusBarColor() {
        return R.color.xn_page_bg;
    }

    public int getNavigationBarColor() {
        return this.getStatusBarColor();
    }

    public void warning(String text) {
        Toast toast = Toast.makeText((Context)this.getApplicationContext(), (CharSequence)text, (int)1);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    public void showWaitDialog(String msg) {
        if (!this.isFinishing()) {
            if (this.mDialog != null && this.mDialog.isShowing()) {
                this.mDialog.dismiss();
            }
            try {
                WeakReference<BaseActivity> weakReference = new WeakReference<BaseActivity>(this);
                if (weakReference.get() != null) {
                    OSLoadingBottomDialog osLoadingBottomDialog = new OSLoadingBottomDialog((Context)weakReference.get());
                    osLoadingBottomDialog.setMessage(msg);
                    this.mDialog = osLoadingBottomDialog.create();
                    this.mDialog.show();
                }
            }
            catch (Exception e) {
                LogUtils.d(Log.getStackTraceString((Throwable)e));
            }
        }
    }

    public void hideWaitDialog() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public void setAppearance(TextView v, int styleId) {
        if (Build.VERSION.SDK_INT >= 23) {
            v.setTextAppearance(styleId);
        } else {
            v.setTextAppearance((Context)this, styleId);
        }
    }

    protected void closeSoftInput(Context context) {
        InputMethodManager inputMethodManager;
        if (context != null && (inputMethodManager = (InputMethodManager)context.getSystemService("input_method")) != null && ((Activity)context).getCurrentFocus() != null) {
            inputMethodManager.hideSoftInputFromWindow(((Activity)context).getCurrentFocus().getWindowToken(), 2);
        }
    }

    protected void showSoftInput(Context context, EditText view) {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        imm.showSoftInput((View)view, 2);
    }

    public boolean dispatchTouchEvent(MotionEvent me) {
        View v;
        if (me.getAction() == 1) {
            View v2 = this.getCurrentFocus();
            if (this.isShouldHideKeyboard(v2, me) && v2 != null) {
                this.hideKeyboard(v2.getWindowToken());
                v2.clearFocus();
            }
        } else if (me.getAction() == 0) {
            this.x = me.getRawX();
            this.y = me.getRawY();
        } else if (me.getAction() == 2 && (Math.abs(me.getRawX() - this.x) > 50.0f || Math.abs(me.getRawY() - this.y) > 50.0f) && (v = this.getCurrentFocus()) != null) {
            this.hideKeyboard(v.getWindowToken());
            v.clearFocus();
        }
        return super.dispatchTouchEvent(me);
    }

    protected boolean isShouldHideKeyboard(View v, MotionEvent event) {
        if (v instanceof EditText) {
            int[] l = new int[]{0, 0};
            v.getLocationInWindow(l);
            int left = l[0];
            int top = l[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            return !(event.getX() > (float)left && event.getX() < (float)right && event.getY() > (float)top && event.getY() < (float)bottom);
        }
        return false;
    }

    public boolean isClickView(View v, MotionEvent event) {
        if (v == null) {
            return false;
        }
        int[] l = new int[]{0, 0};
        v.getLocationInWindow(l);
        int left = l[0];
        int top = l[1];
        int bottom = top + v.getHeight();
        int right = left + v.getWidth();
        return event.getX() > (float)left && event.getX() < (float)right && event.getY() > (float)top && event.getY() < (float)bottom;
    }

    public void hideKeyboard(IBinder token) {
        if (token != null) {
            InputMethodManager im = (InputMethodManager)this.getSystemService("input_method");
            im.hideSoftInputFromWindow(token, 2);
        }
    }

    public int bottomMargin() {
        int navigationH = BaseActivity.getNavigationBarHeight((Context)this);
        if (navigationH > 1) {
            return ScreenUtil.dip2px((float)20.0f);
        }
        return ScreenUtil.dip2px((float)30.0f);
    }

    public static int getNavigationBarHeight(Context context) {
        int navigationBarHeight = -1;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            navigationBarHeight = resources.getDimensionPixelSize(resourceId);
        }
        return navigationBarHeight;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.hideWaitDialog();
        this.mDialog = null;
    }

    public final String getRS(int resId, Object ... formatArgs) {
        if (resId == -1) {
            return "";
        }
        try {
            return this.getString(resId, formatArgs);
        }
        catch (IllegalFormatConversionException | UnknownFormatConversionException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean booleanExtra(String key) {
        try {
            return this.getIntent().getBooleanExtra(key, false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int intExtra(String key, int defaultValue) {
        try {
            return this.getIntent().getIntExtra(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public String stringExtra(String key) {
        try {
            return this.getIntent().getStringExtra(key);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean isKeyboardShowing() {
        Rect r = new Rect();
        View decorView = this.getWindow().getDecorView();
        decorView.getWindowVisibleDisplayFrame(r);
        int displayHeight = r.bottom - r.top;
        int screenHeight = decorView.getHeight();
        return (double)displayHeight / (double)screenHeight < 0.7;
    }
}

