/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.xuanniao.account.comm.net;

import android.app.Activity;
import android.content.Context;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.net.NetCallBack;
import com.transsion.xuanniao.account.comm.net.NetClient;
import com.transsion.xuanniao.account.comm.net.UrlFactory;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import java.util.HashMap;
import okhttp3.Response;

public class NetWorkProxy {
    private static final String TAG = "NetWorkProxy";
    private Context context;

    public NetWorkProxy(Context context) {
        this.context = context;
    }

    public <T> void requestPost(String api, Object params, NetCallBack<T> callBack) {
        if (NetUtils.instance().isNetworkConnected(this.context)) {
            NetClient client = new NetClient();
            client.requestAsyncPost(this.context, UrlFactory.getUrl(api), params, callBack);
        } else {
            if (this.context instanceof BaseActivity) {
                ((BaseActivity)this.context).hideWaitDialog();
            }
            if (this.context instanceof Activity) {
                NetUtils.instance().showSetNet(this.context);
            }
        }
    }

    public Response requestSyncPost(String api, Object params) {
        if (NetUtils.instance().isNetworkConnected(this.context)) {
            NetClient client = new NetClient();
            return client.requestSyncPost(this.context, UrlFactory.getUrl(api), params);
        }
        if (this.context instanceof Activity) {
            NetUtils.instance().showSetNet(this.context);
        }
        return null;
    }

    public <T> void requestPost(String api, Object params, HashMap<String, String> queryParams, NetCallBack<T> callBack) {
        if (NetUtils.instance().isNetworkConnected(this.context)) {
            NetClient client = new NetClient();
            client.requestAsyncPost(this.context, UrlFactory.getUrl(api), params, queryParams, callBack);
        } else {
            if (this.context instanceof BaseActivity) {
                ((BaseActivity)this.context).hideWaitDialog();
            }
            if (this.context instanceof Activity) {
                NetUtils.instance().showSetNet(this.context);
            }
        }
    }

    public <T> void requestGet(String api, HashMap<String, String> queryParams, NetCallBack<T> callBack) {
        if (NetUtils.instance().isNetworkConnected(this.context)) {
            NetClient client = new NetClient();
            client.requestAsyncGet(this.context, UrlFactory.getUrl(api), queryParams, callBack);
        } else {
            if (this.context instanceof BaseActivity) {
                ((BaseActivity)this.context).hideWaitDialog();
            }
            if (this.context instanceof Activity) {
                NetUtils.instance().showSetNet(this.context);
            }
        }
    }

    public Response requestSyncGet(String api, HashMap<String, String> queryParams) {
        if (NetUtils.instance().isNetworkConnected(this.context)) {
            NetClient client = new NetClient();
            return client.requestSyncGet(this.context, UrlFactory.getUrl(api), queryParams);
        }
        if (this.context instanceof Activity) {
            NetUtils.instance().showSetNet(this.context);
        }
        return null;
    }
}

